/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.OAuth2GrantType;
import software.amazon.awssdk.services.appflow.model.OAuth2GrantTypeSupportedListCopier;
import software.amazon.awssdk.services.appflow.model.OAuthScopeListCopier;
import software.amazon.awssdk.services.appflow.model.SalesforceDataTransferApi;
import software.amazon.awssdk.services.appflow.model.SalesforceDataTransferApiListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceMetadata> {
    private static final SdkField<List<String>> O_AUTH_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("oAuthScopes").getter(SalesforceMetadata.getter(SalesforceMetadata::oAuthScopes)).setter(SalesforceMetadata.setter(Builder::oAuthScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DATA_TRANSFER_APIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataTransferApis").getter(SalesforceMetadata.getter(SalesforceMetadata::dataTransferApisAsStrings)).setter(SalesforceMetadata.setter(Builder::dataTransferApisWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferApis").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OAUTH2_GRANT_TYPES_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("oauth2GrantTypesSupported").getter(SalesforceMetadata.getter(SalesforceMetadata::oauth2GrantTypesSupportedAsStrings)).setter(SalesforceMetadata.setter(Builder::oauth2GrantTypesSupportedWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2GrantTypesSupported").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(O_AUTH_SCOPES_FIELD, DATA_TRANSFER_APIS_FIELD, OAUTH2_GRANT_TYPES_SUPPORTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("oAuthScopes", O_AUTH_SCOPES_FIELD);
            this.put("dataTransferApis", DATA_TRANSFER_APIS_FIELD);
            this.put("oauth2GrantTypesSupported", OAUTH2_GRANT_TYPES_SUPPORTED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> oAuthScopes;
    private final List<String> dataTransferApis;
    private final List<String> oauth2GrantTypesSupported;

    private SalesforceMetadata(BuilderImpl builder) {
        this.oAuthScopes = builder.oAuthScopes;
        this.dataTransferApis = builder.dataTransferApis;
        this.oauth2GrantTypesSupported = builder.oauth2GrantTypesSupported;
    }

    public final boolean hasOAuthScopes() {
        return this.oAuthScopes != null && !(this.oAuthScopes instanceof SdkAutoConstructList);
    }

    public final List<String> oAuthScopes() {
        return this.oAuthScopes;
    }

    public final List<SalesforceDataTransferApi> dataTransferApis() {
        return SalesforceDataTransferApiListCopier.copyStringToEnum(this.dataTransferApis);
    }

    public final boolean hasDataTransferApis() {
        return this.dataTransferApis != null && !(this.dataTransferApis instanceof SdkAutoConstructList);
    }

    public final List<String> dataTransferApisAsStrings() {
        return this.dataTransferApis;
    }

    public final List<OAuth2GrantType> oauth2GrantTypesSupported() {
        return OAuth2GrantTypeSupportedListCopier.copyStringToEnum(this.oauth2GrantTypesSupported);
    }

    public final boolean hasOauth2GrantTypesSupported() {
        return this.oauth2GrantTypesSupported != null && !(this.oauth2GrantTypesSupported instanceof SdkAutoConstructList);
    }

    public final List<String> oauth2GrantTypesSupportedAsStrings() {
        return this.oauth2GrantTypesSupported;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOAuthScopes() ? this.oAuthScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataTransferApis() ? this.dataTransferApisAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOauth2GrantTypesSupported() ? this.oauth2GrantTypesSupportedAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceMetadata)) {
            return false;
        }
        SalesforceMetadata other = (SalesforceMetadata)obj;
        return this.hasOAuthScopes() == other.hasOAuthScopes() && Objects.equals(this.oAuthScopes(), other.oAuthScopes()) && this.hasDataTransferApis() == other.hasDataTransferApis() && Objects.equals(this.dataTransferApisAsStrings(), other.dataTransferApisAsStrings()) && this.hasOauth2GrantTypesSupported() == other.hasOauth2GrantTypesSupported() && Objects.equals(this.oauth2GrantTypesSupportedAsStrings(), other.oauth2GrantTypesSupportedAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceMetadata").add("OAuthScopes", this.hasOAuthScopes() ? this.oAuthScopes() : null).add("DataTransferApis", this.hasDataTransferApis() ? this.dataTransferApisAsStrings() : null).add("Oauth2GrantTypesSupported", this.hasOauth2GrantTypesSupported() ? this.oauth2GrantTypesSupportedAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oAuthScopes": {
                return Optional.ofNullable(clazz.cast(this.oAuthScopes()));
            }
            case "dataTransferApis": {
                return Optional.ofNullable(clazz.cast(this.dataTransferApisAsStrings()));
            }
            case "oauth2GrantTypesSupported": {
                return Optional.ofNullable(clazz.cast(this.oauth2GrantTypesSupportedAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceMetadata, T> g) {
        return obj -> g.apply((SalesforceMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> oAuthScopes = DefaultSdkAutoConstructList.getInstance();
        private List<String> dataTransferApis = DefaultSdkAutoConstructList.getInstance();
        private List<String> oauth2GrantTypesSupported = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceMetadata model) {
            this.oAuthScopes(model.oAuthScopes);
            this.dataTransferApisWithStrings(model.dataTransferApis);
            this.oauth2GrantTypesSupportedWithStrings(model.oauth2GrantTypesSupported);
        }

        public final Collection<String> getOAuthScopes() {
            if (this.oAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.oAuthScopes;
        }

        public final void setOAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
        }

        @Override
        public final Builder oAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oAuthScopes(String ... oAuthScopes) {
            this.oAuthScopes(Arrays.asList(oAuthScopes));
            return this;
        }

        public final Collection<String> getDataTransferApis() {
            if (this.dataTransferApis instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataTransferApis;
        }

        public final void setDataTransferApis(Collection<String> dataTransferApis) {
            this.dataTransferApis = SalesforceDataTransferApiListCopier.copy(dataTransferApis);
        }

        @Override
        public final Builder dataTransferApisWithStrings(Collection<String> dataTransferApis) {
            this.dataTransferApis = SalesforceDataTransferApiListCopier.copy(dataTransferApis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTransferApisWithStrings(String ... dataTransferApis) {
            this.dataTransferApisWithStrings(Arrays.asList(dataTransferApis));
            return this;
        }

        @Override
        public final Builder dataTransferApis(Collection<SalesforceDataTransferApi> dataTransferApis) {
            this.dataTransferApis = SalesforceDataTransferApiListCopier.copyEnumToString(dataTransferApis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTransferApis(SalesforceDataTransferApi ... dataTransferApis) {
            this.dataTransferApis(Arrays.asList(dataTransferApis));
            return this;
        }

        public final Collection<String> getOauth2GrantTypesSupported() {
            if (this.oauth2GrantTypesSupported instanceof SdkAutoConstructList) {
                return null;
            }
            return this.oauth2GrantTypesSupported;
        }

        public final void setOauth2GrantTypesSupported(Collection<String> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copy(oauth2GrantTypesSupported);
        }

        @Override
        public final Builder oauth2GrantTypesSupportedWithStrings(Collection<String> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copy(oauth2GrantTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2GrantTypesSupportedWithStrings(String ... oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupportedWithStrings(Arrays.asList(oauth2GrantTypesSupported));
            return this;
        }

        @Override
        public final Builder oauth2GrantTypesSupported(Collection<OAuth2GrantType> oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported = OAuth2GrantTypeSupportedListCopier.copyEnumToString(oauth2GrantTypesSupported);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oauth2GrantTypesSupported(OAuth2GrantType ... oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported(Arrays.asList(oauth2GrantTypesSupported));
            return this;
        }

        public SalesforceMetadata build() {
            return new SalesforceMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceMetadata> {
        public Builder oAuthScopes(Collection<String> var1);

        public Builder oAuthScopes(String ... var1);

        public Builder dataTransferApisWithStrings(Collection<String> var1);

        public Builder dataTransferApisWithStrings(String ... var1);

        public Builder dataTransferApis(Collection<SalesforceDataTransferApi> var1);

        public Builder dataTransferApis(SalesforceDataTransferApi ... var1);

        public Builder oauth2GrantTypesSupportedWithStrings(Collection<String> var1);

        public Builder oauth2GrantTypesSupportedWithStrings(String ... var1);

        public Builder oauth2GrantTypesSupported(Collection<OAuth2GrantType> var1);

        public Builder oauth2GrantTypesSupported(OAuth2GrantType ... var1);
    }
}

