/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.BackendStoragePermissions;
import software.amazon.awssdk.services.amplifybackend.model.ServiceName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackendStorageResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetBackendStorageResourceConfig> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(GetBackendStorageResourceConfig.getter(GetBackendStorageResourceConfig::bucketName)).setter(GetBackendStorageResourceConfig.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<Boolean> IMPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Imported").getter(GetBackendStorageResourceConfig.getter(GetBackendStorageResourceConfig::imported)).setter(GetBackendStorageResourceConfig.setter(Builder::imported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imported").build()}).build();
    private static final SdkField<BackendStoragePermissions> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Permissions").getter(GetBackendStorageResourceConfig.getter(GetBackendStorageResourceConfig::permissions)).setter(GetBackendStorageResourceConfig.setter(Builder::permissions)).constructor(BackendStoragePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(GetBackendStorageResourceConfig.getter(GetBackendStorageResourceConfig::serviceNameAsString)).setter(GetBackendStorageResourceConfig.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, IMPORTED_FIELD, PERMISSIONS_FIELD, SERVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bucketName", BUCKET_NAME_FIELD);
            this.put("imported", IMPORTED_FIELD);
            this.put("permissions", PERMISSIONS_FIELD);
            this.put("serviceName", SERVICE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final Boolean imported;
    private final BackendStoragePermissions permissions;
    private final String serviceName;

    private GetBackendStorageResourceConfig(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.imported = builder.imported;
        this.permissions = builder.permissions;
        this.serviceName = builder.serviceName;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final Boolean imported() {
        return this.imported;
    }

    public final BackendStoragePermissions permissions() {
        return this.permissions;
    }

    public final ServiceName serviceName() {
        return ServiceName.fromValue(this.serviceName);
    }

    public final String serviceNameAsString() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imported());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackendStorageResourceConfig)) {
            return false;
        }
        GetBackendStorageResourceConfig other = (GetBackendStorageResourceConfig)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.imported(), other.imported()) && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.serviceNameAsString(), other.serviceNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetBackendStorageResourceConfig").add("BucketName", (Object)this.bucketName()).add("Imported", (Object)this.imported()).add("Permissions", (Object)this.permissions()).add("ServiceName", (Object)this.serviceNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "Imported": {
                return Optional.ofNullable(clazz.cast(this.imported()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetBackendStorageResourceConfig, T> g) {
        return obj -> g.apply((GetBackendStorageResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private Boolean imported;
        private BackendStoragePermissions permissions;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackendStorageResourceConfig model) {
            this.bucketName(model.bucketName);
            this.imported(model.imported);
            this.permissions(model.permissions);
            this.serviceName(model.serviceName);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final Boolean getImported() {
            return this.imported;
        }

        public final void setImported(Boolean imported) {
            this.imported = imported;
        }

        @Override
        public final Builder imported(Boolean imported) {
            this.imported = imported;
            return this;
        }

        public final BackendStoragePermissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(BackendStoragePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(BackendStoragePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public GetBackendStorageResourceConfig build() {
            return new GetBackendStorageResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetBackendStorageResourceConfig> {
        public Builder bucketName(String var1);

        public Builder imported(Boolean var1);

        public Builder permissions(BackendStoragePermissions var1);

        default public Builder permissions(Consumer<BackendStoragePermissions.Builder> permissions) {
            return this.permissions((BackendStoragePermissions)((BackendStoragePermissions.Builder)BackendStoragePermissions.builder().applyMutation(permissions)).build());
        }

        public Builder serviceName(String var1);

        public Builder serviceName(ServiceName var1);
    }
}

