/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.AmpResponse;
import software.amazon.awssdk.services.amp.model.ScraperStatus;
import software.amazon.awssdk.services.amp.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScraperResponse
extends AmpResponse
implements ToCopyableBuilder<Builder, CreateScraperResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateScraperResponse.getter(CreateScraperResponse::arn)).setter(CreateScraperResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scraperId").getter(CreateScraperResponse.getter(CreateScraperResponse::scraperId)).setter(CreateScraperResponse.setter(Builder::scraperId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperId").build()}).build();
    private static final SdkField<ScraperStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(CreateScraperResponse.getter(CreateScraperResponse::status)).setter(CreateScraperResponse.setter(Builder::status)).constructor(ScraperStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateScraperResponse.getter(CreateScraperResponse::tags)).setter(CreateScraperResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, SCRAPER_ID_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("scraperId", SCRAPER_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String arn;
    private final String scraperId;
    private final ScraperStatus status;
    private final Map<String, String> tags;

    private CreateScraperResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.scraperId = builder.scraperId;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String scraperId() {
        return this.scraperId;
    }

    public final ScraperStatus status() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scraperId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScraperResponse)) {
            return false;
        }
        CreateScraperResponse other = (CreateScraperResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.scraperId(), other.scraperId()) && Objects.equals(this.status(), other.status()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScraperResponse").add("Arn", (Object)this.arn()).add("ScraperId", (Object)this.scraperId()).add("Status", (Object)this.status()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "scraperId": {
                return Optional.ofNullable(clazz.cast(this.scraperId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateScraperResponse, T> g) {
        return obj -> g.apply((CreateScraperResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String scraperId;
        private ScraperStatus status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScraperResponse model) {
            super(model);
            this.arn(model.arn);
            this.scraperId(model.scraperId);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getScraperId() {
            return this.scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        public final ScraperStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ScraperStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ScraperStatus status) {
            this.status = status;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateScraperResponse build() {
            return new CreateScraperResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmpResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScraperResponse> {
        public Builder arn(String var1);

        public Builder scraperId(String var1);

        public Builder status(ScraperStatus var1);

        default public Builder status(Consumer<ScraperStatus.Builder> status) {
            return this.status((ScraperStatus)((ScraperStatus.Builder)ScraperStatus.builder().applyMutation(status)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

