/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecretsManagerSecretConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecretsManagerSecretConfiguration> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(SecretsManagerSecretConfiguration.getter(SecretsManagerSecretConfiguration::kmsKeyId)).setter(SecretsManagerSecretConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> SECRET_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretPolicy").getter(SecretsManagerSecretConfiguration.getter(SecretsManagerSecretConfiguration::secretPolicy)).setter(SecretsManagerSecretConfiguration.setter(Builder::secretPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, SECRET_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("kmsKeyId", KMS_KEY_ID_FIELD);
            this.put("secretPolicy", SECRET_POLICY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String secretPolicy;

    private SecretsManagerSecretConfiguration(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.secretPolicy = builder.secretPolicy;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String secretPolicy() {
        return this.secretPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecretsManagerSecretConfiguration)) {
            return false;
        }
        SecretsManagerSecretConfiguration other = (SecretsManagerSecretConfiguration)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.secretPolicy(), other.secretPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"SecretsManagerSecretConfiguration").add("KmsKeyId", (Object)this.kmsKeyId()).add("SecretPolicy", (Object)this.secretPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "secretPolicy": {
                return Optional.ofNullable(clazz.cast(this.secretPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SecretsManagerSecretConfiguration, T> g) {
        return obj -> g.apply((SecretsManagerSecretConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String secretPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(SecretsManagerSecretConfiguration model) {
            this.kmsKeyId(model.kmsKeyId);
            this.secretPolicy(model.secretPolicy);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSecretPolicy() {
            return this.secretPolicy;
        }

        public final void setSecretPolicy(String secretPolicy) {
            this.secretPolicy = secretPolicy;
        }

        @Override
        public final Builder secretPolicy(String secretPolicy) {
            this.secretPolicy = secretPolicy;
            return this;
        }

        public SecretsManagerSecretConfiguration build() {
            return new SecretsManagerSecretConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecretsManagerSecretConfiguration> {
        public Builder kmsKeyId(String var1);

        public Builder secretPolicy(String var1);
    }
}

