/*
 * Decompiled with CFR 0.152.
 */
package se.akerfeldt.okhttp.signpost;

import java.io.IOException;
import oauth.signpost.exception.OAuthException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import se.akerfeldt.okhttp.signpost.OkHttpOAuthConsumer;

public class SigningInterceptor
implements Interceptor {
    private final OkHttpOAuthConsumer consumer;

    public SigningInterceptor(OkHttpOAuthConsumer consumer) {
        this.consumer = consumer;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        try {
            return chain.proceed((Request)this.consumer.sign(request).unwrap());
        }
        catch (OAuthException e) {
            throw new IOException("Could not sign request", e);
        }
    }
}

