/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j.update;

import com.github.zafarkhaja.semver.Version;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginException;
import ro.fortsoft.pf4j.PluginManager;
import ro.fortsoft.pf4j.PluginState;
import ro.fortsoft.pf4j.PluginWrapper;
import ro.fortsoft.pf4j.update.DefaultUpdateRepository;
import ro.fortsoft.pf4j.update.FileDownloader;
import ro.fortsoft.pf4j.update.PluginInfo;
import ro.fortsoft.pf4j.update.SimpleFileDownloader;
import ro.fortsoft.pf4j.update.UpdateRepository;

public class UpdateManager {
    private static final Logger log = LoggerFactory.getLogger(UpdateManager.class);
    private Path repositoriesJson;
    protected List<UpdateRepository> repositories;
    public PluginManager pluginManager;

    public UpdateManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.repositoriesJson = Paths.get("repositories.json", new String[0]);
    }

    public UpdateManager(PluginManager pluginManager, Path repositoriesJson) {
        this(pluginManager);
        this.repositoriesJson = repositoriesJson;
    }

    public UpdateManager(PluginManager pluginManager, List<UpdateRepository> repos) {
        this(pluginManager);
        this.repositories = repos == null ? new ArrayList() : repos;
    }

    public List<PluginInfo> getAvailablePlugins() {
        ArrayList<PluginInfo> availablePlugins = new ArrayList<PluginInfo>();
        for (PluginInfo plugin : this.getPlugins()) {
            if (this.pluginManager.getPlugin(plugin.id) != null) continue;
            availablePlugins.add(plugin);
        }
        return availablePlugins;
    }

    public boolean hasAvailablePlugins() {
        for (PluginInfo plugin : this.getPlugins()) {
            if (this.pluginManager.getPlugin(plugin.id) != null) continue;
            return true;
        }
        return false;
    }

    public List<PluginInfo> getUpdates() {
        ArrayList<PluginInfo> updates = new ArrayList<PluginInfo>();
        Map<String, PluginInfo> pluginMap = this.getPluginsMap();
        for (PluginWrapper installed : this.pluginManager.getPlugins()) {
            PluginInfo pluginFromRepo = pluginMap.get(installed.getPluginId());
            if (pluginFromRepo == null) continue;
            Version installedVersion = installed.getDescriptor().getVersion();
            if (!pluginFromRepo.hasUpdate(this.getSystemVersion(), installedVersion)) continue;
            updates.add(pluginFromRepo);
        }
        return updates;
    }

    public boolean hasUpdates() {
        return this.getUpdates().size() > 0;
    }

    public List<PluginInfo> getPlugins() {
        ArrayList<PluginInfo> list = new ArrayList<PluginInfo>(this.getPluginsMap().values());
        Collections.sort(list);
        return list;
    }

    public Map<String, PluginInfo> getPluginsMap() {
        HashMap<String, PluginInfo> pluginsMap = new HashMap<String, PluginInfo>();
        for (UpdateRepository repository : this.getRepositories()) {
            pluginsMap.putAll(repository.getPlugins());
        }
        return pluginsMap;
    }

    public List<UpdateRepository> getRepositories() {
        if (this.repositories == null && this.repositoriesJson != null) {
            this.refresh();
        }
        return this.repositories;
    }

    public void setRepositories(List<UpdateRepository> repositories) {
        this.repositories = repositories;
        this.refresh();
    }

    public void addRepository(String id, URL url) {
        for (UpdateRepository ur : this.repositories) {
            if (!ur.getId().equals(id)) continue;
            throw new RuntimeException("Repository with id " + id + " already exists");
        }
        this.repositories.add(new DefaultUpdateRepository(id, url));
    }

    public void addRepository(UpdateRepository newRepo) {
        for (UpdateRepository ur : this.repositories) {
            if (!ur.getId().equals(newRepo.getId())) continue;
            throw new RuntimeException("Repository with id " + newRepo.getId() + " already exists");
        }
        newRepo.refresh();
        this.repositories.add(newRepo);
    }

    public void removeRepository(String id) {
        for (UpdateRepository repo : this.getRepositories()) {
            if (!id.equals(repo.getId())) continue;
            this.repositories.remove(repo);
            break;
        }
        log.warn("Repository with id " + id + " not found, doing nothing");
    }

    public synchronized void refresh() {
        if (this.repositoriesJson != null) {
            this.initRepositoriesFromJson();
        }
        for (UpdateRepository updateRepository : this.repositories) {
            updateRepository.refresh();
        }
    }

    public synchronized boolean installPlugin(String id, String version) throws PluginException {
        Path downloaded = this.downloadPlugin(id, version);
        Path pluginsRoot = this.pluginManager.getPluginsRoot();
        Path file = pluginsRoot.resolve(downloaded.getFileName());
        try {
            Files.move(downloaded, file, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new PluginException("Failed to write file '{}' to plugins folder", new Object[]{file});
        }
        String pluginId = this.pluginManager.loadPlugin(file);
        PluginState state = this.pluginManager.startPlugin(pluginId);
        return PluginState.STARTED.equals((Object)state);
    }

    protected Path downloadPlugin(String id, String version) throws PluginException {
        try {
            URL url = this.findUrlForPlugin(id, version);
            return this.getFileDownloader(id).downloadFile(url);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e, "Error during download of plugin {}", new Object[]{id});
        }
    }

    protected FileDownloader getFileDownloader(String pluginId) {
        for (UpdateRepository ur : this.repositories) {
            if (ur.getPlugin(pluginId) == null || ur.getFileDownloader() == null) continue;
            return ur.getFileDownloader();
        }
        return new SimpleFileDownloader();
    }

    protected URL findUrlForPlugin(String id, String version) throws PluginException {
        PluginInfo plugin = this.getPluginsMap().get(id);
        if (plugin == null) {
            log.info("Plugin with id {} does not exist in any repository", (Object)id);
            throw new PluginException("Plugin with id {} not found in any repository", new Object[]{id});
        }
        try {
            if (version == null) {
                return new URL(plugin.getLastRelease((Version)this.getSystemVersion()).url);
            }
            for (PluginInfo.PluginRelease release : plugin.releases) {
                if (!Version.valueOf((String)version).equals((Object)Version.valueOf((String)release.version)) || release.url == null) continue;
                return new URL(release.url);
            }
        }
        catch (MalformedURLException e) {
            throw new PluginException((Throwable)e);
        }
        throw new PluginException("Plugin {} with version @{} does not exist in the repository", new Object[]{id, version});
    }

    public boolean updatePlugin(String id, String version) throws PluginException {
        if (this.pluginManager.getPlugin(id) == null) {
            throw new PluginException("Plugin {} cannot be updated since it is not installed", new Object[]{id});
        }
        PluginInfo pi = this.getPluginsMap().get(id);
        if (pi == null) {
            throw new PluginException("Plugin {} does not exist in any repository", new Object[]{id});
        }
        Version installedVersion = this.pluginManager.getPlugin(id).getDescriptor().getVersion();
        if (!pi.hasUpdate(this.getSystemVersion(), installedVersion)) {
            log.warn("Plugin {} does not have an update available which is compatible with system version", (Object)id, (Object)this.getSystemVersion());
            return false;
        }
        Path downloaded = this.downloadPlugin(id, version);
        if (!this.pluginManager.deletePlugin(id)) {
            return false;
        }
        Path pluginsRoot = this.pluginManager.getPluginsRoot();
        Path file = pluginsRoot.resolve(downloaded.getFileName());
        try {
            Files.move(downloaded, file, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new PluginException("Failed to write plugin file {} to plugin folder", new Object[]{file});
        }
        String newPluginId = this.pluginManager.loadPlugin(file);
        PluginState state = this.pluginManager.startPlugin(newPluginId);
        return PluginState.STARTED.equals((Object)state);
    }

    public boolean uninstallPlugin(String id) {
        return this.pluginManager.deletePlugin(id);
    }

    protected synchronized void initRepositoriesFromJson() {
        FileReader reader;
        try {
            log.debug("Read repositories from '{}'", (Object)this.repositoriesJson);
            reader = new FileReader(this.repositoriesJson.toFile());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.repositories = Collections.emptyList();
            return;
        }
        Gson gson = new GsonBuilder().create();
        UpdateRepository[] items = (UpdateRepository[])gson.fromJson((Reader)reader, DefaultUpdateRepository[].class);
        this.repositories = Arrays.asList(items);
    }

    private Version getSystemVersion() {
        return this.pluginManager.getSystemVersion();
    }
}

