/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j.update;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginException;
import ro.fortsoft.pf4j.update.FileDownloader;

public class SimpleFileDownloader
implements FileDownloader {
    private static final Logger log = LoggerFactory.getLogger(SimpleFileDownloader.class);

    @Override
    public Path downloadFile(URL fileUrl) throws PluginException, IOException {
        switch (fileUrl.getProtocol()) {
            case "http": 
            case "https": 
            case "ftp": {
                return this.downloadFileHttp(fileUrl);
            }
            case "file": {
                return this.copyLocalFile(fileUrl);
            }
        }
        throw new PluginException("URL protocol {} not supported", new Object[]{fileUrl.getProtocol()});
    }

    protected Path copyLocalFile(URL fileUrl) throws IOException, PluginException {
        Path destination = Files.createTempDirectory("pf4j-update-downloader", new FileAttribute[0]);
        destination.toFile().deleteOnExit();
        try {
            Path fromFile = Paths.get(fileUrl.toURI());
            String path = fileUrl.getPath();
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            Path toFile = destination.resolve(fileName);
            Files.copy(fromFile, toFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            this.validateDownload(fileUrl, toFile);
            return toFile;
        }
        catch (URISyntaxException e) {
            throw new PluginException("Something wrong with given URL", (Throwable)e);
        }
    }

    protected Path downloadFileHttp(URL fileUrl) throws IOException, PluginException {
        int length;
        Path destination = Files.createTempDirectory("pf4j-update-downloader", new FileAttribute[0]);
        destination.toFile().deleteOnExit();
        String path = fileUrl.getPath();
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        Path file = destination.resolve(fileName);
        URLConnection connection = fileUrl.openConnection();
        connection.connect();
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        if (httpConnection.getResponseCode() == 401) {
            throw new ConnectException("HTTP Authorization failure");
        }
        long lastModified = httpConnection.getHeaderFieldDate("Last-Modified", System.currentTimeMillis());
        InputStream is = null;
        for (int i = 0; i < 3; ++i) {
            try {
                is = connection.getInputStream();
                break;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                continue;
            }
        }
        if (is == null) {
            throw new ConnectException("Can't get '" + fileUrl + " to '" + file + "'");
        }
        FileOutputStream fos = new FileOutputStream(file.toFile());
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) >= 0) {
            fos.write(buffer, 0, length);
        }
        fos.close();
        is.close();
        log.debug("Set last modified of '{}' to '{}'", (Object)file, (Object)lastModified);
        Files.setLastModifiedTime(file, FileTime.fromMillis(lastModified));
        this.validateDownload(fileUrl, file);
        return file;
    }

    protected void validateDownload(URL originalUrl, Path downloadedFile) throws PluginException {
        try {
            if (Files.isRegularFile(downloadedFile, new LinkOption[0]) && Files.size(downloadedFile) > 0L) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new PluginException("Failed downloading file {}", new Object[]{downloadedFile});
    }
}

