/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j.update;

import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.ExpressionParser;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginInfo
implements Serializable,
Comparable<PluginInfo> {
    private static final Logger log = LoggerFactory.getLogger(PluginInfo.class);
    public String id;
    public String name;
    public String description;
    public String provider;
    public String projectUrl;
    public List<PluginRelease> releases;
    private String repositoryId;
    private Map<Version, PluginRelease> lastRelease = new HashMap<Version, PluginRelease>();

    public PluginRelease getLastRelease(Version systemVersion) {
        if (!this.lastRelease.containsKey(systemVersion)) {
            for (PluginRelease release : this.releases) {
                Expression requires = release.getRequiresExpression();
                if (!systemVersion.equals((Object)Version.forIntegers((int)0, (int)0, (int)0)) && !systemVersion.satisfies(requires)) continue;
                if (this.lastRelease.get(systemVersion) == null) {
                    this.lastRelease.put(systemVersion, release);
                    continue;
                }
                if (release.compareTo(this.lastRelease.get(systemVersion)) <= 0) continue;
                this.lastRelease.put(systemVersion, release);
            }
        }
        return this.lastRelease.get(systemVersion);
    }

    public boolean hasUpdate(Version systemVersion, Version installedVersion) {
        PluginRelease last = this.getLastRelease(systemVersion);
        return last != null && Version.valueOf((String)last.version).greaterThan(installedVersion);
    }

    @Override
    public int compareTo(PluginInfo o) {
        return this.id.compareTo(o.id);
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public static class PluginRelease
    implements Serializable,
    Comparable<PluginRelease> {
        public String version;
        public Date date;
        public String requires;
        public String url;

        @Override
        public int compareTo(PluginRelease o) {
            return Version.valueOf((String)this.version).compareTo(Version.valueOf((String)o.version));
        }

        public Expression getRequiresExpression() {
            try {
                return (Expression)ExpressionParser.newInstance().parse(this.requires == null ? "*" : this.requires);
            }
            catch (Exception e) {
                log.warn("Failed to parse 'requires' expression {} for plugin {}. Allowing all versions", new Object[]{this.requires, this.url, e});
                return (Expression)ExpressionParser.newInstance().parse("*");
            }
        }
    }
}

