/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j.update;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.update.FileDownloader;
import ro.fortsoft.pf4j.update.PluginInfo;
import ro.fortsoft.pf4j.update.SimpleFileDownloader;
import ro.fortsoft.pf4j.update.UpdateRepository;
import ro.fortsoft.pf4j.update.util.LenientDateTypeAdapter;

public class DefaultUpdateRepository
implements UpdateRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultUpdateRepository.class);
    private String pluginsJsonFileName = "plugins.json";
    private String id;
    private URL url;
    private Map<String, PluginInfo> plugins;

    public DefaultUpdateRepository(String id, URL url) {
        this.id = id;
        this.url = url;
    }

    public DefaultUpdateRepository(String id, URL url, String pluginsJsonFileName) {
        this(id, url);
        this.pluginsJsonFileName = pluginsJsonFileName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public Map<String, PluginInfo> getPlugins() {
        if (this.plugins == null) {
            this.initPlugins();
        }
        return this.plugins;
    }

    @Override
    public PluginInfo getPlugin(String id) {
        return this.getPlugins().get(id);
    }

    private void initPlugins() {
        InputStreamReader pluginsJsonReader;
        try {
            URL pluginsUrl = new URL(this.getUrl(), this.pluginsJsonFileName);
            log.debug("Read plugins of '{}' repository from '{}'", (Object)this.id, (Object)pluginsUrl);
            pluginsJsonReader = new InputStreamReader(pluginsUrl.openStream());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.plugins = Collections.emptyMap();
            return;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new LenientDateTypeAdapter()).create();
        PluginInfo[] items = (PluginInfo[])gson.fromJson((Reader)pluginsJsonReader, PluginInfo[].class);
        this.plugins = new HashMap<String, PluginInfo>(items.length);
        for (PluginInfo p : items) {
            for (PluginInfo.PluginRelease r : p.releases) {
                try {
                    r.url = new URL(this.getUrl(), r.url).toString();
                    if (r.date.getTime() != 0L) continue;
                    log.warn("Illegal release date when parsing {}@{}, setting to epoch", (Object)p.id, (Object)r.version);
                }
                catch (MalformedURLException e) {
                    log.warn("Skipping release {} of plugin {} due to failure to build valid absolute URL. Url was {}{}", new Object[]{r.version, p.id, this.getUrl(), r.url});
                }
            }
            p.setRepositoryId(this.getId());
            this.plugins.put(p.id, p);
        }
        log.debug("Found {} plugins in repository '{}'", (Object)this.plugins.size(), (Object)this.id);
    }

    @Override
    public void refresh() {
        this.plugins = null;
    }

    @Override
    public FileDownloader getFileDownloader() {
        return new SimpleFileDownloader();
    }

    public String getPluginsJsonFileName() {
        return this.pluginsJsonFileName;
    }

    public void setPluginsJsonFileName(String pluginsJsonFileName) {
        this.pluginsJsonFileName = pluginsJsonFileName;
    }
}

