/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoIdValue;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class MediaInfoIdQueryAction {
    private final ApiConnection connection;
    private final String siteIri;

    public MediaInfoIdQueryAction(ApiConnection connection, String siteIri) {
        this.connection = connection;
        this.siteIri = siteIri;
    }

    public Map<String, MediaInfoIdValue> getMediaInfoIds(List<String> fileNames) throws IOException, MediaWikiApiErrorException {
        ArrayList<Object> fileNamesWithPrefix = new ArrayList<Object>();
        for (String string : fileNames) {
            Object object = string.startsWith("File:") ? string : "File:" + string;
            fileNamesWithPrefix.add(object);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("action", "query");
        parameters.put("titles", ApiConnection.implodeObjects(fileNamesWithPrefix));
        HashMap<String, MediaInfoIdValue> hashMap = new HashMap<String, MediaInfoIdValue>();
        JsonNode root = this.connection.sendJsonRequest("POST", parameters);
        if (!root.has("query")) {
            return hashMap;
        }
        JsonNode query = root.get("query");
        HashMap<String, Object> normalizedMap = new HashMap<String, Object>();
        if (query.has("normalized")) {
            ArrayNode normalized = (ArrayNode)query.get("normalized");
            Iterator iterator = normalized.elements();
            while (iterator.hasNext()) {
                JsonNode next = (JsonNode)iterator.next();
                String from = next.get("from").asText();
                String to = next.get("to").asText();
                normalizedMap.put(from, to);
            }
        }
        HashMap<String, MediaInfoIdValue> midMap = new HashMap<String, MediaInfoIdValue>();
        JsonNode pages = query.get("pages");
        Iterator iterator = pages.fields();
        while (iterator.hasNext()) {
            Map.Entry page = (Map.Entry)iterator.next();
            String pageId = (String)page.getKey();
            String title = ((JsonNode)page.getValue()).get("title").textValue();
            if (pageId.startsWith("-")) continue;
            midMap.put(title, Datamodel.makeMediaInfoIdValue((String)("M" + pageId), (String)this.siteIri));
        }
        for (String fileName : fileNames) {
            Object fileNameWithPrefix = fileName.startsWith("File:") ? fileName : "File:" + fileName;
            String normalizedFileName = (String)normalizedMap.getOrDefault(fileNameWithPrefix, fileNameWithPrefix);
            hashMap.put(fileName, (MediaInfoIdValue)midMap.get(normalizedFileName));
        }
        return hashMap;
    }
}

