/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.implementation.StatementDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LabeledStatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

abstract class LabeledStatementDocumentImpl
extends StatementDocumentImpl
implements LabeledStatementDocument {
    protected final Map<String, MonolingualTextValue> labels;

    public LabeledStatementDocumentImpl(EntityIdValue id, List<MonolingualTextValue> labels, List<StatementGroup> claims, long revisionId) {
        super(id, claims, revisionId);
        this.labels = labels == null ? Collections.emptyMap() : LabeledStatementDocumentImpl.constructTermMap(labels);
    }

    LabeledStatementDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="labels") Map<String, MonolingualTextValue> labels, @JsonProperty(value="claims") Map<String, List<StatementImpl.PreStatement>> claims, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        super(jsonId, claims, revisionId, siteIri);
        this.labels = labels == null ? Collections.emptyMap() : labels;
    }

    protected LabeledStatementDocumentImpl(EntityIdValue subject, Map<String, MonolingualTextValue> labels, Map<String, List<Statement>> claims, long revisionId) {
        super(subject, claims, revisionId);
        this.labels = labels;
    }

    @Override
    @JsonProperty(value="labels")
    public Map<String, MonolingualTextValue> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    protected static Map<String, MonolingualTextValue> constructTermMap(List<MonolingualTextValue> terms) {
        HashMap<String, MonolingualTextValue> map = new HashMap<String, MonolingualTextValue>();
        for (MonolingualTextValue term : terms) {
            String language = term.getLanguageCode();
            if (map.containsKey(language)) {
                throw new IllegalArgumentException("Multiple terms provided for the same language.");
            }
            map.put(language, LabeledStatementDocumentImpl.toTerm(term));
        }
        return map;
    }

    protected static Map<String, MonolingualTextValue> withTerm(Map<String, MonolingualTextValue> values, MonolingualTextValue value) {
        HashMap<String, MonolingualTextValue> newValues = new HashMap<String, MonolingualTextValue>(values);
        newValues.put(value.getLanguageCode(), LabeledStatementDocumentImpl.toTerm(value));
        return newValues;
    }

    private static MonolingualTextValue toTerm(MonolingualTextValue term) {
        return term instanceof TermImpl ? term : new TermImpl(term.getLanguageCode(), term.getText());
    }
}

