/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Objects;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityRedirectDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityUpdate;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormUpdate;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemUpdate;
import org.wikidata.wdtk.datamodel.interfaces.LabeledStatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeUpdate;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoUpdate;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyUpdate;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseUpdate;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;

public class Equality {
    public static boolean equalsEntityIdValue(EntityIdValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof EntityIdValue)) {
            return false;
        }
        EntityIdValue other = (EntityIdValue)o2;
        return o1.getId().equals(other.getId()) && o1.getSiteIri().equals(other.getSiteIri()) && o1.getEntityType().equals(other.getEntityType());
    }

    public static boolean equalsDatatypeIdValue(DatatypeIdValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof DatatypeIdValue && o1.getIri().equals(((DatatypeIdValue)o2).getIri()) && o1.getJsonString().equals(((DatatypeIdValue)o2).getJsonString());
    }

    public static boolean equalsTimeValue(TimeValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof TimeValue)) {
            return false;
        }
        TimeValue other = (TimeValue)o2;
        return o1.getYear() == other.getYear() && o1.getMonth() == other.getMonth() && o1.getDay() == other.getDay() && o1.getHour() == other.getHour() && o1.getMinute() == other.getMinute() && o1.getSecond() == other.getSecond() && o1.getPrecision() == other.getPrecision() && o1.getBeforeTolerance() == other.getBeforeTolerance() && o1.getAfterTolerance() == other.getAfterTolerance() && o1.getTimezoneOffset() == other.getTimezoneOffset() && o1.getPreferredCalendarModel().equals(other.getPreferredCalendarModel());
    }

    public static boolean equalsGlobeCoordinatesValue(GlobeCoordinatesValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof GlobeCoordinatesValue)) {
            return false;
        }
        GlobeCoordinatesValue other = (GlobeCoordinatesValue)o2;
        return o1.getLatitude() == other.getLatitude() && o1.getLongitude() == other.getLongitude() && o1.getPrecision() == other.getPrecision() && o1.getGlobe().equals(other.getGlobe());
    }

    public static boolean equalsStringValue(StringValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof StringValue && o1.getString().equals(((StringValue)o2).getString());
    }

    public static boolean equalsMonolingualTextValue(MonolingualTextValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof MonolingualTextValue)) {
            return false;
        }
        MonolingualTextValue other = (MonolingualTextValue)o2;
        return o1.getText().equals(other.getText()) && o1.getLanguageCode().equals(other.getLanguageCode());
    }

    public static boolean equalsQuantityValue(QuantityValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof QuantityValue)) {
            return false;
        }
        QuantityValue other = (QuantityValue)o2;
        return o1.getNumericValue().equals(other.getNumericValue()) && Objects.equals(o1.getLowerBound(), other.getLowerBound()) && Objects.equals(o1.getUpperBound(), other.getUpperBound()) && o1.getUnit().equals(other.getUnit());
    }

    public static boolean equalsValueSnak(ValueSnak o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof ValueSnak && o1.getPropertyId().equals(((ValueSnak)o2).getPropertyId()) && o1.getValue().equals(((ValueSnak)o2).getValue());
    }

    public static boolean equalsSomeValueSnak(SomeValueSnak o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof SomeValueSnak && o1.getPropertyId().equals(((SomeValueSnak)o2).getPropertyId());
    }

    public static boolean equalsNoValueSnak(NoValueSnak o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof NoValueSnak && o1.getPropertyId().equals(((NoValueSnak)o2).getPropertyId());
    }

    public static boolean equalsSnakGroup(SnakGroup o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof SnakGroup && o1.getSnaks().equals(((SnakGroup)o2).getSnaks());
    }

    public static boolean equalsClaim(Claim o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof Claim)) {
            return false;
        }
        Claim other = (Claim)o2;
        return o1.getSubject().equals(other.getSubject()) && o1.getMainSnak().equals(other.getMainSnak()) && o1.getQualifiers().equals(other.getQualifiers());
    }

    public static boolean equalsReference(Reference o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof Reference && o1.getSnakGroups().equals(((Reference)o2).getSnakGroups());
    }

    public static boolean equalsStatement(Statement o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)o2;
        return o1.getSubject().equals(other.getSubject()) && o1.getMainSnak().equals(other.getMainSnak()) && o1.getQualifiers().equals(other.getQualifiers()) && o1.getReferences().equals(other.getReferences()) && o1.getRank() == other.getRank() && o1.getStatementId().equals(other.getStatementId());
    }

    public static boolean equalsStatementGroup(StatementGroup o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof StatementGroup && o1.getStatements().equals(((StatementGroup)o2).getStatements());
    }

    public static boolean equalsSiteLink(SiteLink o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof SiteLink)) {
            return false;
        }
        SiteLink other = (SiteLink)o2;
        return o1.getPageTitle().equals(other.getPageTitle()) && o1.getSiteKey().equals(other.getSiteKey()) && o1.getBadges().equals(other.getBadges());
    }

    public static boolean equalsPropertyDocument(PropertyDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof PropertyDocument)) {
            return false;
        }
        PropertyDocument other = (PropertyDocument)o2;
        return Equality.equalsTermedDocument(o1, other) && o1.getDatatype().equals(other.getDatatype()) && o1.getStatementGroups().equals(other.getStatementGroups());
    }

    public static boolean equalsItemDocument(ItemDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof ItemDocument)) {
            return false;
        }
        ItemDocument other = (ItemDocument)o2;
        return Equality.equalsTermedDocument(o1, other) && o1.getSiteLinks().equals(other.getSiteLinks()) && o1.getStatementGroups().equals(other.getStatementGroups());
    }

    public static boolean equalsLexemeDocument(LexemeDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof LexemeDocument)) {
            return false;
        }
        LexemeDocument other = (LexemeDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getLanguage().equals(other.getLanguage()) && o1.getLexicalCategory().equals(other.getLexicalCategory()) && o1.getLemmas().equals(other.getLemmas()) && o1.getStatementGroups().equals(other.getStatementGroups()) && o1.getForms().equals(other.getForms()) && o1.getSenses().equals(other.getSenses()) && o1.getRevisionId() == other.getRevisionId();
    }

    public static boolean equalsFormDocument(FormDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof FormDocument)) {
            return false;
        }
        FormDocument other = (FormDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getGrammaticalFeatures().equals(other.getGrammaticalFeatures()) && o1.getRepresentations().equals(other.getRepresentations()) && o1.getStatementGroups().equals(other.getStatementGroups()) && o1.getRevisionId() == other.getRevisionId();
    }

    public static boolean equalsSenseDocument(SenseDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof SenseDocument)) {
            return false;
        }
        SenseDocument other = (SenseDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getGlosses().equals(other.getGlosses()) && o1.getStatementGroups().equals(other.getStatementGroups()) && o1.getRevisionId() == other.getRevisionId();
    }

    public static boolean equalsMediaInfoDocument(MediaInfoDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof MediaInfoDocument)) {
            return false;
        }
        MediaInfoDocument other = (MediaInfoDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getLabels().equals(other.getLabels()) && o1.getStatementGroups().equals(other.getStatementGroups()) && o1.getRevisionId() == other.getRevisionId();
    }

    private static boolean equalsTermedDocument(TermedDocument o1, TermedDocument other) {
        return o1.getEntityId().equals(other.getEntityId()) && o1.getAliases().equals(other.getAliases()) && o1.getDescriptions().equals(other.getDescriptions()) && o1.getLabels().equals(other.getLabels()) && o1.getRevisionId() == other.getRevisionId();
    }

    public static boolean equalsEntityRedirectDocument(EntityRedirectDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof EntityRedirectDocument)) {
            return false;
        }
        EntityRedirectDocument other = (EntityRedirectDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getTargetId().equals(other.getTargetId()) && o1.getRevisionId() == other.getRevisionId();
    }

    public static boolean equalsTermUpdate(TermUpdate o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof TermUpdate)) {
            return false;
        }
        TermUpdate other = (TermUpdate)o2;
        return Objects.equals(o1.getModified(), other.getModified()) && Objects.equals(o1.getRemoved(), other.getRemoved());
    }

    public static boolean equalsAliasUpdate(AliasUpdate o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof AliasUpdate)) {
            return false;
        }
        AliasUpdate other = (AliasUpdate)o2;
        return Objects.equals(o1.getRecreated(), other.getRecreated()) && Objects.equals(o1.getAdded(), other.getAdded()) && Objects.equals(o1.getRemoved(), other.getRemoved());
    }

    public static boolean equalsStatementUpdate(StatementUpdate o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof StatementUpdate)) {
            return false;
        }
        StatementUpdate other = (StatementUpdate)o2;
        return Objects.equals(o1.getAdded(), other.getAdded()) && Objects.equals(o1.getReplaced(), other.getReplaced()) && Objects.equals(o1.getRemoved(), other.getRemoved());
    }

    private static boolean equalsEntityUpdate(EntityUpdate o1, EntityUpdate o2) {
        return Objects.equals(o1.getEntityId(), o2.getEntityId()) && o1.getBaseRevisionId() == o2.getBaseRevisionId();
    }

    private static boolean equalsStatementDocumentUpdate(StatementDocumentUpdate o1, StatementDocumentUpdate o2) {
        return Equality.equalsEntityUpdate(o1, o2) && Objects.equals(o1.getStatements(), o2.getStatements());
    }

    private static boolean equalsLabeledStatementDocumentUpdate(LabeledStatementDocumentUpdate o1, LabeledStatementDocumentUpdate o2) {
        return Equality.equalsStatementDocumentUpdate(o1, o2) && Objects.equals(o1.getLabels(), o2.getLabels());
    }

    private static boolean equalsTermedStatementDocumentUpdate(TermedStatementDocumentUpdate o1, TermedStatementDocumentUpdate o2) {
        return Equality.equalsLabeledStatementDocumentUpdate(o1, o2) && Objects.equals(o1.getDescriptions(), o2.getDescriptions()) && Objects.equals(o1.getAliases(), o2.getAliases());
    }

    public static boolean equalsMediaInfoUpdate(MediaInfoUpdate o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof MediaInfoUpdate)) {
            return false;
        }
        MediaInfoUpdate other = (MediaInfoUpdate)o2;
        return Equality.equalsLabeledStatementDocumentUpdate(o1, other);
    }

    public static boolean equalsItemUpdate(ItemUpdate o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof ItemUpdate)) {
            return false;
        }
        ItemUpdate other = (ItemUpdate)o2;
        return Equality.equalsTermedStatementDocumentUpdate(o1, other) && Objects.equals(o1.getModifiedSiteLinks(), other.getModifiedSiteLinks()) && Objects.equals(o1.getRemovedSiteLinks(), other.getRemovedSiteLinks());
    }

    public static boolean equalsPropertyUpdate(PropertyUpdate o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof PropertyUpdate)) {
            return false;
        }
        PropertyUpdate other = (PropertyUpdate)o2;
        return Equality.equalsTermedStatementDocumentUpdate(o1, other);
    }

    public static boolean equalsSenseUpdate(SenseUpdate o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof SenseUpdate)) {
            return false;
        }
        SenseUpdate other = (SenseUpdate)o2;
        return Equality.equalsStatementDocumentUpdate(o1, other) && Objects.equals(o1.getGlosses(), other.getGlosses());
    }

    public static boolean equalsFormUpdate(FormUpdate o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof FormUpdate)) {
            return false;
        }
        FormUpdate other = (FormUpdate)o2;
        return Equality.equalsStatementDocumentUpdate(o1, other) && Objects.equals(o1.getRepresentations(), other.getRepresentations()) && Objects.equals(o1.getGrammaticalFeatures(), other.getGrammaticalFeatures());
    }

    public static boolean equalsLexemeUpdate(LexemeUpdate o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof LexemeUpdate)) {
            return false;
        }
        LexemeUpdate other = (LexemeUpdate)o2;
        return Equality.equalsStatementDocumentUpdate(o1, other) && Objects.equals(o1.getLanguage(), other.getLanguage()) && Objects.equals(o1.getLexicalCategory(), other.getLexicalCategory()) && Objects.equals(o1.getLemmas(), other.getLemmas()) && Objects.equals(o1.getAddedSenses(), other.getAddedSenses()) && Objects.equals(o1.getUpdatedSenses(), other.getUpdatedSenses()) && Objects.equals(o1.getRemovedSenses(), other.getRemovedSenses()) && Objects.equals(o1.getAddedForms(), other.getAddedForms()) && Objects.equals(o1.getUpdatedForms(), other.getUpdatedForms()) && Objects.equals(o1.getRemovedForms(), other.getRemovedForms());
    }
}

