/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

final class MessageToken
implements Token {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\r\n|\n|\r");
    private static final String NEW_LINE = System.getProperty("line.separator");

    MessageToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.MESSAGE);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        String message = logEntry.getMessage();
        if (message != null) {
            builder.append(NEW_LINE_PATTERN.matcher(message).replaceAll(NEW_LINE));
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        statement.setString(index, logEntry.getMessage());
    }
}

