/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.core;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tinylog.Level;
import org.tinylog.Supplier;
import org.tinylog.core.ConfigurationParser;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.core.TinylogContextProvider;
import org.tinylog.core.WritingThread;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.ContextProvider;
import org.tinylog.provider.InternalLogger;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.runtime.RuntimeProvider;
import org.tinylog.runtime.Timestamp;
import org.tinylog.writers.Writer;

public class TinylogLoggingProvider
implements LoggingProvider {
    private final TinylogContextProvider context = new TinylogContextProvider();
    private final Level globalLevel = ConfigurationParser.getGlobalLevel();
    private final Map<String, Level> customLevels = ConfigurationParser.getCustomLevels();
    private final List<String> knownTags = ConfigurationParser.getTags();
    private final Collection<Writer>[][] writers;
    private final Collection<LogEntryValue>[][] requiredLogEntryValues;
    private final BitSet fullStackTraceRequired;
    private final WritingThread writingThread;

    public TinylogLoggingProvider() {
        Level minimumLevel = TinylogLoggingProvider.calculateMinimumLevel(this.globalLevel, this.customLevels);
        boolean hasWritingThread = ConfigurationParser.isWritingThreadEnabled();
        this.writers = ConfigurationParser.createWriters(this.knownTags, minimumLevel, hasWritingThread);
        this.requiredLogEntryValues = TinylogLoggingProvider.calculateRequiredLogEntryValues(this.writers);
        this.fullStackTraceRequired = TinylogLoggingProvider.calculateFullStackTraceRequirements(this.requiredLogEntryValues);
        WritingThread writingThread = this.writingThread = hasWritingThread ? TinylogLoggingProvider.createWritingThread(this.writers) : null;
        if (ConfigurationParser.isAutoShutdownEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        TinylogLoggingProvider.this.shutdown();
                    }
                    catch (InterruptedException ex) {
                        InternalLogger.log((Level)Level.ERROR, (Throwable)ex, (String)"Interrupted while waiting for shutdown");
                    }
                }
            });
        }
    }

    public ContextProvider getContextProvider() {
        return this.context;
    }

    public Level getMinimumLevel() {
        Level level = Level.OFF;
        for (int tagIndex = 0; tagIndex < this.writers.length; ++tagIndex) {
            for (int levelIndex = Level.TRACE.ordinal(); levelIndex < level.ordinal(); ++levelIndex) {
                if (this.writers[tagIndex][levelIndex].size() <= 0) continue;
                level = Level.values()[levelIndex];
            }
        }
        return level;
    }

    public Level getMinimumLevel(String tag) {
        int tagIndex = this.getTagIndex(tag);
        for (int levelIndex = Level.TRACE.ordinal(); levelIndex < Level.OFF.ordinal(); ++levelIndex) {
            if (this.writers[tagIndex][levelIndex].size() <= 0) continue;
            return Level.values()[levelIndex];
        }
        return Level.OFF;
    }

    public boolean isEnabled(int depth, String tag, Level level) {
        Level activeLevel;
        if (this.customLevels.isEmpty()) {
            activeLevel = this.globalLevel;
        } else {
            String className = RuntimeProvider.getCallerClassName((int)(depth + 1));
            activeLevel = this.getLevel(className);
        }
        return activeLevel.ordinal() <= level.ordinal() && this.writers[this.getTagIndex(tag)][level.ordinal()].size() > 0;
    }

    public void log(int depth, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        Level activeLevel;
        int tagIndex = this.getTagIndex(tag);
        StackTraceElement stackTraceElement = this.fullStackTraceRequired.get(tagIndex) ? RuntimeProvider.getCallerStackTraceElement((int)(depth + 1)) : null;
        if (this.customLevels.isEmpty()) {
            if (stackTraceElement == null && this.requiredLogEntryValues[tagIndex][level.ordinal()].contains((Object)LogEntryValue.CLASS)) {
                stackTraceElement = new StackTraceElement(RuntimeProvider.getCallerClassName((int)(depth + 1)), "<unknown>", null, -1);
            }
            activeLevel = this.globalLevel;
        } else {
            if (stackTraceElement == null) {
                stackTraceElement = new StackTraceElement(RuntimeProvider.getCallerClassName((int)(depth + 1)), "<unknown>", null, -1);
            }
            activeLevel = this.getLevel(stackTraceElement.getClassName());
        }
        if (activeLevel.ordinal() <= level.ordinal()) {
            LogEntry logEntry = this.createLogEntry(stackTraceElement, tag, tagIndex, level, exception, formatter, obj, arguments);
            this.output(logEntry, this.writers[tagIndex][logEntry.getLevel().ordinal()]);
        }
    }

    public void log(String loggerClassName, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        Level activeLevel;
        int tagIndex = this.getTagIndex(tag);
        StackTraceElement stackTraceElement = this.fullStackTraceRequired.get(tagIndex) ? RuntimeProvider.getCallerStackTraceElement((String)loggerClassName) : null;
        if (this.customLevels.isEmpty()) {
            if (stackTraceElement == null && this.requiredLogEntryValues[tagIndex][level.ordinal()].contains((Object)LogEntryValue.CLASS)) {
                stackTraceElement = new StackTraceElement(RuntimeProvider.getCallerClassName((String)loggerClassName), "<unknown>", null, -1);
            }
            activeLevel = this.globalLevel;
        } else {
            if (stackTraceElement == null) {
                stackTraceElement = new StackTraceElement(RuntimeProvider.getCallerClassName((String)loggerClassName), "<unknown>", null, -1);
            }
            activeLevel = this.getLevel(stackTraceElement.getClassName());
        }
        if (activeLevel.ordinal() <= level.ordinal()) {
            LogEntry logEntry = this.createLogEntry(stackTraceElement, tag, tagIndex, level, exception, formatter, obj, arguments);
            this.output(logEntry, this.writers[tagIndex][logEntry.getLevel().ordinal()]);
        }
    }

    public void shutdown() throws InterruptedException {
        if (this.writingThread == null) {
            for (Writer writer : TinylogLoggingProvider.getAllWriters(this.writers)) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    InternalLogger.log((Level)Level.ERROR, (Throwable)ex, (String)"Failed to close writer");
                }
            }
        } else {
            this.writingThread.shutdown();
            this.writingThread.join();
        }
    }

    private static Level calculateMinimumLevel(Level globalLevel, Map<String, Level> customLevels) {
        Level minimumLevel = globalLevel;
        for (Level level : customLevels.values()) {
            if (level.ordinal() >= minimumLevel.ordinal()) continue;
            minimumLevel = level;
        }
        return minimumLevel;
    }

    private static Collection<LogEntryValue>[][] calculateRequiredLogEntryValues(Collection<Writer>[][] writers) {
        Collection[][] logEntryValues = new Collection[writers.length][Level.values().length - 1];
        for (int tagIndex = 0; tagIndex < writers.length; ++tagIndex) {
            for (int levelIndex = 0; levelIndex < Level.OFF.ordinal(); ++levelIndex) {
                EnumSet<LogEntryValue> values = EnumSet.noneOf(LogEntryValue.class);
                for (Writer writer : writers[tagIndex][levelIndex]) {
                    values.addAll(writer.getRequiredLogEntryValues());
                }
                logEntryValues[tagIndex][levelIndex] = values;
            }
        }
        return logEntryValues;
    }

    private static BitSet calculateFullStackTraceRequirements(Collection<LogEntryValue>[][] logEntryValues) {
        BitSet result = new BitSet(logEntryValues.length);
        for (int i = 0; i < logEntryValues.length; ++i) {
            Collection<LogEntryValue> values = logEntryValues[i][Level.ERROR.ordinal()];
            if (!values.contains((Object)LogEntryValue.METHOD) && !values.contains((Object)LogEntryValue.FILE) && !values.contains((Object)LogEntryValue.LINE)) continue;
            result.set(i);
        }
        return result;
    }

    private static WritingThread createWritingThread(Collection<Writer>[][] matrix) {
        Collection<Writer> writers = TinylogLoggingProvider.getAllWriters(matrix);
        WritingThread thread = new WritingThread(writers);
        thread.start();
        return thread;
    }

    private static Collection<Writer> getAllWriters(Collection<Writer>[][] matrix) {
        Set<Writer> writers = Collections.newSetFromMap(new IdentityHashMap());
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                writers.addAll(matrix[i][j]);
            }
        }
        return writers;
    }

    private int getTagIndex(String tag) {
        if (tag == null) {
            return 0;
        }
        int index = this.knownTags.indexOf(tag);
        return index == -1 ? this.knownTags.size() + 1 : index + 1;
    }

    private Level getLevel(String className) {
        Level customLevel;
        String key = className;
        while ((customLevel = this.customLevels.get(key)) == null) {
            int index = key.lastIndexOf(46);
            if (index == -1) {
                return this.globalLevel;
            }
            key = key.substring(0, index);
        }
        return customLevel;
    }

    private LogEntry createLogEntry(StackTraceElement stackTraceElement, String tag, int tagIndex, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object[] arguments) {
        String message;
        int lineNumber;
        String fileName;
        String methodName;
        String className;
        Map<String, String> context;
        Collection<LogEntryValue> required = this.requiredLogEntryValues[tagIndex][level.ordinal()];
        Timestamp timestamp = RuntimeProvider.createTimestamp();
        Thread thread = required.contains((Object)LogEntryValue.THREAD) ? Thread.currentThread() : null;
        Map<String, String> map = context = required.contains((Object)LogEntryValue.CONTEXT) ? this.context.getMapping() : null;
        if (stackTraceElement == null) {
            className = null;
            methodName = null;
            fileName = null;
            lineNumber = -1;
        } else {
            className = stackTraceElement.getClassName();
            methodName = stackTraceElement.getMethodName();
            fileName = stackTraceElement.getFileName();
            lineNumber = stackTraceElement.getLineNumber();
        }
        if (arguments == null || arguments.length == 0) {
            Object evaluatedObject = obj instanceof Supplier ? ((Supplier)obj).get() : obj;
            message = evaluatedObject == null ? null : evaluatedObject.toString();
        } else {
            message = formatter.format((String)obj, arguments);
        }
        return new LogEntry(timestamp, thread, context, className, methodName, fileName, lineNumber, tag, level, message, exception);
    }

    private void output(LogEntry logEntry, Iterable<Writer> writers) {
        if (this.writingThread == null) {
            for (Writer writer : writers) {
                try {
                    writer.write(logEntry);
                }
                catch (Exception ex) {
                    InternalLogger.log((Level)Level.ERROR, (Throwable)ex, (String)("Failed to write log entry '" + logEntry.getMessage() + "'"));
                }
            }
        } else {
            for (Writer writer : writers) {
                this.writingThread.add(writer, logEntry);
            }
        }
    }

    public Collection<Writer> getWriters(String tag) {
        HashSet<Writer> collectedWriters = new HashSet<Writer>();
        int tagIndex = this.getTagIndex(tag);
        if (tagIndex > this.knownTags.size()) {
            return collectedWriters;
        }
        for (int j = 0; j < this.writers[tagIndex].length; ++j) {
            collectedWriters.addAll(this.writers[tagIndex][j]);
        }
        return collectedWriters;
    }

    public Collection<Writer> getWriters() {
        HashSet<Writer> collectedWriters = new HashSet<Writer>();
        for (int tagIndex = 0; tagIndex < this.writers.length; ++tagIndex) {
            for (int levelIndex = 0; levelIndex < this.writers[tagIndex].length; ++levelIndex) {
                collectedWriters.addAll(this.writers[tagIndex][levelIndex]);
            }
        }
        return collectedWriters;
    }
}

