/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.validation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageContextErrors;
import org.springframework.binding.validation.ValidationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.validation.DefaultValidationContext;

public class ValidationHelper {
    private static final Log logger = LogFactory.getLog(ValidationHelper.class);
    private final Object model;
    private final RequestContext requestContext;
    private final String eventId;
    private final String modelName;
    private final ExpressionParser expressionParser;
    private final MessageCodesResolver messageCodesResolver;
    private final MappingResults mappingResults;

    public ValidationHelper(Object model, RequestContext requestContext, String eventId, String modelName, ExpressionParser expressionParser, MessageCodesResolver messageCodesResolver, MappingResults mappingResults) {
        Assert.notNull((Object)model, (String)"The model to validate is required");
        Assert.notNull((Object)requestContext, (String)"The request context for the validator is required");
        this.model = model;
        this.requestContext = requestContext;
        this.eventId = eventId;
        this.modelName = modelName;
        this.expressionParser = expressionParser;
        this.messageCodesResolver = messageCodesResolver;
        this.mappingResults = mappingResults;
    }

    public void validate() {
        this.invokeModelValidationMethod(this.model);
        Object validator = this.getModelValidator();
        if (validator != null) {
            this.invokeModelValidator(this.model, validator);
        }
    }

    private void invokeModelValidationMethod(Object model) {
        this.invokeValidateMethodForCurrentState(model);
        this.invokeDefaultValidateMethod(model);
    }

    private boolean invokeValidateMethodForCurrentState(Object model) {
        String methodName = "validate" + StringUtils.capitalize((String)this.requestContext.getCurrentState().getId());
        Method validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)methodName, (Class[])new Class[]{ValidationContext.class});
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state model validation method '" + methodName + "(ValidationContext)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)methodName, (Class[])new Class[]{MessageContext.class});
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{this.requestContext.getMessageContext()});
            return true;
        }
        validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)methodName, (Class[])new Class[]{Errors.class});
        if (validateMethod != null) {
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state model validation method '" + methodName + "(Errors)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{errors});
            return true;
        }
        return false;
    }

    private boolean invokeDefaultValidateMethod(Object model) {
        Method validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)"validate", (Class[])new Class[]{ValidationContext.class});
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking default model validation method 'validate(ValidationContext)'");
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        validateMethod = ReflectionUtils.findMethod(model.getClass(), (String)"validate", (Class[])new Class[]{Errors.class});
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invoking default model validation method 'validate(Errors)'");
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{errors});
            return true;
        }
        return false;
    }

    private Object getModelValidator() {
        String validatorName;
        ApplicationContext beanFactory = this.requestContext.getActiveFlow().getApplicationContext();
        if (beanFactory != null && StringUtils.hasText((String)this.modelName) && beanFactory.containsBean(validatorName = String.valueOf(this.modelName) + "Validator")) {
            return beanFactory.getBean(validatorName);
        }
        return null;
    }

    private void invokeModelValidator(Object model, Object validator) {
        this.invokeValidatorValidateMethodForCurrentState(model, validator);
        this.invokeValidatorDefaultValidateMethod(model, validator);
    }

    private boolean invokeValidatorValidateMethodForCurrentState(Object model, Object validator) {
        String methodName = "validate" + StringUtils.capitalize((String)this.requestContext.getCurrentState().getId());
        Method validateMethod = this.findValidationMethod(model, validator, methodName, ValidationContext.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state validator method '" + ClassUtils.getShortName(validator.getClass()) + "." + methodName + "(" + ClassUtils.getShortName(model.getClass()) + ", ValidationContext)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        validateMethod = this.findValidationMethod(model, validator, methodName, Errors.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking current state validator method '" + ClassUtils.getShortName(validator.getClass()) + "." + methodName + "(" + ClassUtils.getShortName(model.getClass()) + ", Errors)'"));
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, errors});
            return true;
        }
        validateMethod = this.findValidationMethod(model, validator, methodName, MessageContext.class);
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, this.requestContext.getMessageContext()});
            return true;
        }
        return false;
    }

    private boolean invokeValidatorDefaultValidateMethod(Object model, Object validator) {
        if (validator instanceof Validator) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking Spring Validator '" + ClassUtils.getShortName(validator.getClass()) + "'"));
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ((Validator)validator).validate(model, (Errors)errors);
            return true;
        }
        Method validateMethod = this.findValidationMethod(model, validator, "validate", ValidationContext.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking default validator method '" + ClassUtils.getShortName(validator.getClass()) + ".validate(" + ClassUtils.getShortName(model.getClass()) + ", ValidationContext)'"));
            }
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults)});
            return true;
        }
        validateMethod = this.findValidationMethod(model, validator, "validate", Errors.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking default validator method '" + ClassUtils.getShortName(validator.getClass()) + ".validate(" + ClassUtils.getShortName(model.getClass()) + ", Errors)'"));
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, errors});
            return true;
        }
        return false;
    }

    private Method findValidationMethod(Object model, Object validator, String methodName, Class context) {
        Class modelClass = AopUtils.getTargetClass((Object)model);
        ArrayList modelSearchClasses = new ArrayList();
        while (modelClass != null) {
            modelSearchClasses.add(modelClass);
            modelClass = modelClass.getSuperclass();
        }
        for (Class clazz : modelSearchClasses) {
            Method method = ReflectionUtils.findMethod(validator.getClass(), (String)methodName, (Class[])new Class[]{clazz, context});
            if (method == null) continue;
            return method;
        }
        return null;
    }
}

