/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class UrlHandlerFilter
extends OncePerRequestFilter {
    private static final Log logger = LogFactory.getLog(UrlHandlerFilter.class);
    private final MultiValueMap<Handler, PathPattern> handlers;

    private UrlHandlerFilter(MultiValueMap<Handler, PathPattern> handlers) {
        this.handlers = new LinkedMultiValueMap(handlers);
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        RequestPath previousPath;
        RequestPath path = previousPath = (RequestPath)request.getAttribute(ServletRequestPathUtils.PATH_ATTRIBUTE);
        try {
            if (path == null) {
                path = ServletRequestPathUtils.parseAndCache(request);
            }
            for (Map.Entry entry : this.handlers.entrySet()) {
                if (!((Handler)entry.getKey()).supports(request, path)) continue;
                for (PathPattern pattern : (List)entry.getValue()) {
                    if (!pattern.matches(path)) continue;
                    ((Handler)entry.getKey()).handle(request, response, chain);
                    return;
                }
            }
        }
        finally {
            if (previousPath != null) {
                ServletRequestPathUtils.setParsedRequestPath(previousPath, (ServletRequest)request);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static Builder.TrailingSlashSpec trailingSlashHandler(String ... pathPatterns) {
        return new DefaultBuilder().trailingSlashHandler(pathPatterns);
    }

    private static interface Handler {
        public boolean supports(HttpServletRequest var1, RequestPath var2);

        public void handle(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;
    }

    private static final class DefaultBuilder
    implements Builder {
        private final PathPatternParser patternParser = new PathPatternParser();
        private final MultiValueMap<Handler, PathPattern> handlers = new LinkedMultiValueMap();

        private DefaultBuilder() {
        }

        @Override
        public Builder.TrailingSlashSpec trailingSlashHandler(String ... patterns) {
            return new DefaultTrailingSlashSpec(patterns);
        }

        private DefaultBuilder addHandler(List<PathPattern> pathPatterns, Handler handler) {
            pathPatterns.forEach(pattern -> this.handlers.add((Object)handler, pattern));
            return this;
        }

        @Override
        public UrlHandlerFilter build() {
            return new UrlHandlerFilter(this.handlers);
        }

        private final class DefaultTrailingSlashSpec
        implements Builder.TrailingSlashSpec {
            private final List<PathPattern> pathPatterns;
            private @Nullable Consumer<HttpServletRequest> interceptor;

            private DefaultTrailingSlashSpec(String[] patterns) {
                this.pathPatterns = Arrays.stream(patterns).map(pattern -> pattern.endsWith("**") || pattern.endsWith("/") ? pattern : pattern + "/").map(DefaultBuilder.this.patternParser::parse).toList();
            }

            @Override
            public Builder.TrailingSlashSpec intercept(Consumer<HttpServletRequest> consumer) {
                this.interceptor = this.interceptor != null ? this.interceptor.andThen(consumer) : consumer;
                return this;
            }

            @Override
            public Builder redirect(HttpStatus status) {
                RedirectTrailingSlashHandler handler = new RedirectTrailingSlashHandler(status, this.interceptor);
                return DefaultBuilder.this.addHandler(this.pathPatterns, handler);
            }

            @Override
            public Builder wrapRequest() {
                RequestWrappingTrailingSlashHandler handler = new RequestWrappingTrailingSlashHandler(this.interceptor);
                return DefaultBuilder.this.addHandler(this.pathPatterns, handler);
            }
        }
    }

    public static interface Builder {
        public TrailingSlashSpec trailingSlashHandler(String ... var1);

        public UrlHandlerFilter build();

        public static interface TrailingSlashSpec {
            public TrailingSlashSpec intercept(Consumer<HttpServletRequest> var1);

            public Builder redirect(HttpStatus var1);

            public Builder wrapRequest();
        }
    }

    private static class TrailingSlashHttpServletRequest
    extends HttpServletRequestWrapper {
        private final String requestURI;
        private final StringBuffer requestURL;
        private final String servletPath;
        private final String pathInfo;

        TrailingSlashHttpServletRequest(HttpServletRequest request, String requestURI, String requestURL, String servletPath, String pathInfo) {
            super(request);
            this.requestURI = requestURI;
            this.requestURL = new StringBuffer(requestURL);
            this.servletPath = servletPath;
            this.pathInfo = pathInfo;
        }

        public String getRequestURI() {
            return this.requestURI;
        }

        public StringBuffer getRequestURL() {
            return this.requestURL;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }
    }

    private static final class RequestWrappingTrailingSlashHandler
    extends AbstractTrailingSlashHandler {
        RequestWrappingTrailingSlashHandler(@Nullable Consumer<HttpServletRequest> interceptor) {
            super(interceptor);
        }

        @Override
        public void handleInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
            String servletPath = request.getServletPath();
            String pathInfo = request.getPathInfo();
            boolean hasPathInfo = StringUtils.hasText((String)pathInfo);
            request = new TrailingSlashHttpServletRequest((HttpServletRequest)request, this.trimTrailingSlash(request.getRequestURI()), this.trimTrailingSlash(request.getRequestURL().toString()), hasPathInfo ? servletPath : this.trimTrailingSlash(servletPath), hasPathInfo ? this.trimTrailingSlash(pathInfo) : pathInfo);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static final class RedirectTrailingSlashHandler
    extends AbstractTrailingSlashHandler {
        private final HttpStatus httpStatus;

        RedirectTrailingSlashHandler(HttpStatus httpStatus, @Nullable Consumer<HttpServletRequest> interceptor) {
            super(interceptor);
            this.httpStatus = httpStatus;
        }

        @Override
        public void handleInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException {
            response.resetBuffer();
            response.setStatus(this.httpStatus.value());
            response.setHeader("Location", this.trimTrailingSlash(request.getRequestURI()));
            response.flushBuffer();
        }
    }

    private static abstract class AbstractTrailingSlashHandler
    implements Handler {
        private static final Consumer<HttpServletRequest> defaultInterceptor = request -> {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Handling trailing slash URL: " + request.getMethod() + " " + request.getRequestURI()));
            }
        };
        private final Consumer<HttpServletRequest> interceptor;

        protected AbstractTrailingSlashHandler(@Nullable Consumer<HttpServletRequest> interceptor) {
            this.interceptor = interceptor != null ? interceptor : defaultInterceptor;
        }

        @Override
        public boolean supports(HttpServletRequest request, RequestPath path) {
            List<PathContainer.Element> elements = path.pathWithinApplication().elements();
            return elements.size() > 1 && elements.get(elements.size() - 1).value().equals("/");
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
            this.interceptor.accept(request);
            this.handleInternal(request, response, chain);
        }

        protected abstract void handleInternal(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;

        protected String trimTrailingSlash(String path) {
            int index = StringUtils.hasLength((String)path) ? path.lastIndexOf(47) : -1;
            return index != -1 ? path.substring(0, index) : path;
        }
    }
}

