/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jspecify.annotations.Nullable;
import org.springframework.web.accept.InvalidApiVersionException;
import org.springframework.web.accept.MissingApiVersionException;

public interface ApiVersionStrategy {
    public @Nullable String resolveVersion(HttpServletRequest var1);

    public Comparable<?> parseVersion(String var1);

    public void validateVersion(@Nullable Comparable<?> var1, HttpServletRequest var2) throws MissingApiVersionException, InvalidApiVersionException;

    public @Nullable Comparable<?> getDefaultVersion();

    default public @Nullable Comparable<?> resolveParseAndValidateVersion(HttpServletRequest request) {
        String value = this.resolveVersion(request);
        if (value == null) {
            return this.getDefaultVersion();
        }
        try {
            Comparable<?> version = this.parseVersion(value);
            this.validateVersion(version, request);
            return version;
        }
        catch (Exception ex) {
            throw new InvalidApiVersionException(value, null, ex);
        }
    }

    public void handleDeprecations(Comparable<?> var1, HttpServletRequest var2, HttpServletResponse var3);
}

