/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.bean.override.BeanOverrideHandler;
import org.springframework.test.context.bean.override.BeanOverrideRegistry;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class BeanOverrideTestExecutionListener
extends AbstractTestExecutionListener {
    public static final int ORDER = 1950;

    @Override
    public int getOrder() {
        return 1950;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        BeanOverrideTestExecutionListener.injectFields(testContext);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        Object reinjectDependenciesAttribute = testContext.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE);
        if (Boolean.TRUE.equals(reinjectDependenciesAttribute)) {
            BeanOverrideTestExecutionListener.injectFields(testContext);
        }
    }

    private static void injectFields(TestContext testContext) {
        Object testInstance = testContext.getTestInstance();
        Class<?> testClass = testInstance.getClass();
        List<BeanOverrideHandler> handlers = BeanOverrideHandler.forTestClass(testClass);
        if (!handlers.isEmpty()) {
            ApplicationContext applicationContext = testContext.getApplicationContext();
            Assert.state((boolean)applicationContext.containsBean("org.springframework.test.context.bean.override.internalBeanOverrideRegistry"), () -> "Test class %s declares @BeanOverride fields %s, but no BeanOverrideHandler has been registered. If you are using @ContextHierarchy, ensure that context names for bean overrides match configured @ContextConfiguration names.".formatted(testClass.getSimpleName(), handlers.stream().map(BeanOverrideHandler::getField).filter(Objects::nonNull).map(Field::getName).toList()));
            BeanOverrideRegistry beanOverrideRegistry = (BeanOverrideRegistry)applicationContext.getBean("org.springframework.test.context.bean.override.internalBeanOverrideRegistry", BeanOverrideRegistry.class);
            for (BeanOverrideHandler handler : handlers) {
                Field field = handler.getField();
                Assert.state((field != null ? 1 : 0) != 0, () -> "BeanOverrideHandler must have a non-null field: " + String.valueOf(handler));
                Object bean = beanOverrideRegistry.getBeanForHandler(handler, field.getType());
                Assert.state((bean != null ? 1 : 0) != 0, () -> "No bean override instance found for BeanOverrideHandler %s. If you are using @ContextHierarchy, ensure that context names for bean overrides match configured @ContextConfiguration names.".formatted(handler));
                BeanOverrideTestExecutionListener.injectField(field, testInstance, bean);
            }
        }
    }

    private static void injectField(Field field, Object target, Object bean) {
        try {
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)target, (Object)bean);
        }
        catch (Throwable ex) {
            throw new BeanCreationException("Could not inject field '" + String.valueOf(field) + "'", ex);
        }
    }
}

