/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.config.xml;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.social.config.xml.InMemoryConnectionRepositoryBeanDefinitionParser;
import org.springframework.social.config.xml.JdbcConnectionRepositoryBeanDefinitionParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SocialNamespaceHandler
implements NamespaceHandler {
    private final Map<String, BeanDefinitionParser> parsers = new HashMap<String, BeanDefinitionParser>();

    public void init() {
        this.loadParsers();
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String name = parserContext.getDelegate().getLocalName((Node)element);
        BeanDefinitionParser parser = this.parsers.get(name);
        if (parser == null) {
            this.loadParsers();
        }
        if (parser == null) {
            this.reportUnsupportedNodeType(name, parserContext, element);
            return null;
        }
        return parser.parse(element, parserContext);
    }

    public BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder definition, ParserContext parserContext) {
        return definition;
    }

    private void reportUnsupportedNodeType(String name, ParserContext parserContext, Node node) {
        parserContext.getReaderContext().fatal("Social namespace does not support decoration of " + (node instanceof Element ? "element" : "attribute") + " [" + name + "]", (Object)node);
    }

    private void loadParsers() {
        this.parsers.put("jdbc-connection-repository", new JdbcConnectionRepositoryBeanDefinitionParser());
        this.parsers.put("in-memory-connection-repository", new InMemoryConnectionRepositoryBeanDefinitionParser());
    }
}

