/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.List;
import java.util.concurrent.Executor;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareErrorHandler;
import org.springframework.kafka.listener.KafkaExceptionLogLevelAware;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.util.Assert;

public class ContainerStoppingErrorHandler
extends KafkaExceptionLogLevelAware
implements ContainerAwareErrorHandler {
    private final Executor executor;

    public ContainerStoppingErrorHandler() {
        this.executor = new SimpleAsyncTaskExecutor();
    }

    public ContainerStoppingErrorHandler(Executor executor) {
        Assert.notNull((Object)executor, (String)"'executor' cannot be null");
        this.executor = executor;
    }

    @Override
    public void handle(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        this.executor.execute(() -> container.stop());
        int n = 0;
        while (container.isRunning() && n++ < 100) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new KafkaException("Stopped container", this.getLogLevel(), thrownException);
    }
}

