/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.core;

import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.integration.mqtt.core.AbstractMqttClientManager;
import org.springframework.integration.mqtt.event.MqttConnectionFailedEvent;
import org.springframework.integration.mqtt.support.MqttUtils;
import org.springframework.util.Assert;

public class Mqttv3ClientManager
extends AbstractMqttClientManager<IMqttAsyncClient, MqttConnectOptions>
implements MqttCallbackExtended {
    private final MqttConnectOptions connectionOptions;
    private MqttClientPersistence persistence;

    public Mqttv3ClientManager(String url, String clientId) {
        this(Mqttv3ClientManager.buildDefaultConnectionOptions(url), clientId);
    }

    public Mqttv3ClientManager(MqttConnectOptions connectionOptions, String clientId) {
        super(clientId);
        Assert.notNull((Object)connectionOptions, (String)"'connectionOptions' is required");
        this.connectionOptions = connectionOptions;
        Object[] serverURIs = connectionOptions.getServerURIs();
        Assert.notEmpty((Object[])serverURIs, (String)"'serverURIs' must be provided in the 'MqttConnectionOptions'");
        this.setUrl((String)serverURIs[0]);
        if (!connectionOptions.isAutomaticReconnect()) {
            this.logger.info((Object)"If this `ClientManager` is used from message-driven channel adapters, it is recommended to set 'automaticReconnect' MQTT connection option. Otherwise connection check and reconnect should be done manually.");
        }
    }

    private static MqttConnectOptions buildDefaultConnectionOptions(String url) {
        Assert.notNull((Object)url, (String)"'url' is required");
        MqttConnectOptions connectOptions = new MqttConnectOptions();
        connectOptions.setServerURIs(new String[]{url});
        connectOptions.setAutomaticReconnect(true);
        return connectOptions;
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public MqttConnectOptions getConnectionInfo() {
        return this.connectionOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        block12: {
            this.lock.lock();
            try {
                IMqttAsyncClient client = (IMqttAsyncClient)this.getClient();
                if (client == null) {
                    try {
                        client = this.createClient();
                    }
                    catch (MqttException e) {
                        throw new IllegalStateException("could not start client manager", e);
                    }
                }
                this.setClient(client);
                try {
                    client.connect(this.connectionOptions).waitForCompletion(this.getCompletionTimeout());
                }
                catch (MqttException ex) {
                    if (this.connectionOptions.isAutomaticReconnect()) {
                        try {
                            client.reconnect();
                        }
                        catch (MqttException re) {
                            this.logger.error((Object)"MQTT client failed to connect. Never happens.", (Throwable)re);
                        }
                        break block12;
                    }
                    ApplicationEventPublisher applicationEventPublisher = this.getApplicationEventPublisher();
                    if (applicationEventPublisher != null) {
                        applicationEventPublisher.publishEvent((ApplicationEvent)new MqttConnectionFailedEvent(this, ex));
                        break block12;
                    }
                    this.logger.error((Object)("Could not start client manager, client_id=" + this.getClientId()), (Throwable)ex);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private IMqttAsyncClient createClient() throws MqttException {
        String url = this.getUrl();
        String clientId = this.getClientId();
        MqttAsyncClient client = new MqttAsyncClient(url, clientId, this.persistence);
        client.setManualAcks(this.isManualAcks());
        client.setCallback((MqttCallback)this);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            IMqttAsyncClient client = (IMqttAsyncClient)this.getClient();
            if (client == null) {
                return;
            }
            try {
                client.disconnectForcibly(this.getDisconnectCompletionTimeout());
                if (this.getConnectionInfo().isAutomaticReconnect()) {
                    MqttUtils.stopClientReconnectCycle(client);
                }
            }
            catch (MqttException e) {
                this.logger.error((Object)"Could not disconnect from the client", (Throwable)e);
            }
            finally {
                try {
                    client.close();
                }
                catch (MqttException e) {
                    this.logger.error((Object)"Could not close the client", (Throwable)e);
                }
                this.setClient(null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void connectionLost(Throwable cause) {
        this.lock.lock();
        try {
            this.logger.error((Object)("Connection lost, client_id=" + this.getClientId()), cause);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        this.getCallbacks().forEach(callback -> callback.connectComplete(reconnect));
    }

    public void messageArrived(String topic, MqttMessage message) {
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
    }
}

