/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.ConditionVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.ExpressionVisitor;
import org.springframework.data.relational.core.sql.render.FilteredSubtreeVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.lang.Nullable;

class ComparisonVisitor
extends FilteredSubtreeVisitor {
    private final RenderContext context;
    private final Comparison condition;
    private final RenderTarget target;
    private final StringBuilder part = new StringBuilder();
    @Nullable
    private PartRenderer current;

    ComparisonVisitor(RenderContext context, Comparison condition, RenderTarget target) {
        super(it -> it == condition);
        this.condition = condition;
        this.target = target;
        this.context = context;
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof Condition) {
            ConditionVisitor visitor = new ConditionVisitor(this.context);
            this.current = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        if (segment instanceof Expression) {
            ExpressionVisitor visitor = new ExpressionVisitor(this.context);
            this.current = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        throw new IllegalStateException("Cannot provide visitor for " + segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.current != null) {
            if (this.part.length() != 0) {
                this.part.append(' ').append(this.condition.getComparator()).append(' ');
            }
            this.part.append(this.current.getRenderedPart());
            this.current = null;
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Visitable segment) {
        this.target.onRendered(this.part);
        return super.leaveMatched(segment);
    }
}

