/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.domain.Sort;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OrderByField
extends AbstractSegment {
    private final Expression expression;
    @Nullable
    private final Sort.Direction direction;
    private final Sort.NullHandling nullHandling;

    private OrderByField(Expression expression, @Nullable Sort.Direction direction, Sort.NullHandling nullHandling) {
        super(expression);
        Assert.notNull((Object)expression, (String)"Order by expression must not be null");
        Assert.notNull((Object)nullHandling, (String)"NullHandling by expression must not be null");
        this.expression = expression;
        this.direction = direction;
        this.nullHandling = nullHandling;
    }

    public static OrderByField from(Expression expression) {
        return new OrderByField(expression, null, Sort.NullHandling.NATIVE);
    }

    public static OrderByField from(Expression expression, Sort.Direction direction) {
        return new OrderByField(expression, direction, Sort.NullHandling.NATIVE);
    }

    public OrderByField asc() {
        return new OrderByField(this.expression, Sort.Direction.ASC, this.nullHandling);
    }

    public OrderByField desc() {
        return new OrderByField(this.expression, Sort.Direction.DESC, this.nullHandling);
    }

    public OrderByField withNullHandling(Sort.NullHandling nullHandling) {
        return new OrderByField(this.expression, this.direction, nullHandling);
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Nullable
    public Sort.Direction getDirection() {
        return this.direction;
    }

    public Sort.NullHandling getNullHandling() {
        return this.nullHandling;
    }

    @Override
    public String toString() {
        return this.direction != null ? this.expression + " " + this.direction : this.expression.toString();
    }
}

