/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.ParsingUtils;
import org.springframework.util.Assert;

public interface NamingStrategy {
    public static final NamingStrategy INSTANCE = new NamingStrategy(){};

    default public String getSchema() {
        return "";
    }

    default public String getTableName(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null.");
        return ParsingUtils.reconcatenateCamelCase((String)type.getSimpleName(), (String)"_");
    }

    default public String getColumnName(RelationalPersistentProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null.");
        return ParsingUtils.reconcatenateCamelCase((String)property.getName(), (String)"_");
    }

    default public String getQualifiedTableName(Class<?> type) {
        return this.getSchema() + (this.getSchema().equals("") ? "" : ".") + this.getTableName(type);
    }

    default public String getReverseColumnName(RelationalPersistentProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null.");
        return property.getOwner().getTableName();
    }

    default public String getReverseColumnName(PersistentPropertyPathExtension path) {
        return this.getTableName(path.getIdDefiningParentPath().getLeafEntity().getType());
    }

    default public String getKeyColumn(RelationalPersistentProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null.");
        return this.getReverseColumnName(property) + "_key";
    }
}

