/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ReadOffset {
    private final String offset;

    private ReadOffset(String offset) {
        this.offset = offset;
    }

    public static ReadOffset latest() {
        return new ReadOffset("$");
    }

    public static ReadOffset lastConsumed() {
        return new ReadOffset(">");
    }

    public static ReadOffset from(String offset) {
        Assert.hasText((String)offset, (String)"Offset must not be empty");
        return new ReadOffset(offset);
    }

    public static ReadOffset from(RecordId offset) {
        if (offset.shouldBeAutoGenerated()) {
            return ReadOffset.latest();
        }
        return ReadOffset.from(offset.getValue());
    }

    public String getOffset() {
        return this.offset;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadOffset that = (ReadOffset)o;
        return ObjectUtils.nullSafeEquals((Object)this.offset, (Object)that.offset);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.offset);
    }

    public String toString() {
        return "ReadOffset(offset=" + this.getOffset() + ")";
    }
}

