/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.util.TypeInformation;

public class Neo4jPersistentEntity<T>
extends BasicPersistentEntity<T, Neo4jPersistentProperty> {
    Neo4jPersistentEntity(TypeInformation<T> information) {
        super(information);
    }

    protected IsNewStrategy getFallbackIsNewStrategy() {
        return new Neo4jIsNewStrategy(this);
    }

    protected Neo4jPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(Neo4jPersistentProperty property) {
        Neo4jPersistentProperty existingIdProperty;
        if (!property.isIdProperty()) {
            return null;
        }
        Neo4jPersistentProperty preferredIdProperty = existingIdProperty = (Neo4jPersistentProperty)this.getIdProperty();
        if (existingIdProperty == null) {
            preferredIdProperty = property;
        } else {
            if (existingIdProperty.getPropertyType() == property.getPropertyType()) {
                throw new MappingException(String.format("Attempt to add id property %s but already have property %s registered as id. Check your mapping configuration!", property.getField(), existingIdProperty.getField()));
            }
            if (existingIdProperty.getPropertyType() == Neo4jPersistentProperty.PropertyType.INTERNAL_ID_PROPERTY && property.getPropertyType() == Neo4jPersistentProperty.PropertyType.ID_PROPERTY) {
                preferredIdProperty = property;
            }
        }
        return preferredIdProperty;
    }

    private static class Neo4jIsNewStrategy
    implements IsNewStrategy {
        private final Neo4jPersistentEntity<?> entity;

        private Neo4jIsNewStrategy(Neo4jPersistentEntity<?> entity) {
            this.entity = entity;
        }

        public boolean isNew(Object bean) {
            PersistentProperty property = this.entity.getRequiredIdProperty();
            Object value = this.entity.getPropertyAccessor(bean).getProperty(property);
            return value == null || value instanceof Long && (Long)value < 0L;
        }
    }
}

