/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.jdbc.core.JdbcAggregateChangeExecutionContext;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.DbActionExecutionException;
import org.springframework.lang.Nullable;

class AggregateChangeExecutor {
    private final JdbcConverter converter;
    private final DataAccessStrategy accessStrategy;

    AggregateChangeExecutor(JdbcConverter converter, DataAccessStrategy accessStrategy) {
        this.converter = converter;
        this.accessStrategy = accessStrategy;
    }

    @Nullable
    <T> T execute(AggregateChange<T> aggregateChange) {
        JdbcAggregateChangeExecutionContext executionContext = new JdbcAggregateChangeExecutionContext(this.converter, this.accessStrategy);
        aggregateChange.forEachAction(action -> this.execute((DbAction<?>)action, executionContext));
        Object root = executionContext.populateIdsIfNecessary();
        if (root == null) {
            root = aggregateChange.getEntity();
        }
        return root;
    }

    private void execute(DbAction<?> action, JdbcAggregateChangeExecutionContext executionContext) {
        block14: {
            try {
                if (action instanceof DbAction.InsertRoot) {
                    executionContext.executeInsertRoot((DbAction.InsertRoot)action);
                    break block14;
                }
                if (action instanceof DbAction.Insert) {
                    executionContext.executeInsert((DbAction.Insert)action);
                    break block14;
                }
                if (action instanceof DbAction.InsertBatch) {
                    executionContext.executeInsertBatch((DbAction.InsertBatch)action);
                    break block14;
                }
                if (action instanceof DbAction.UpdateRoot) {
                    executionContext.executeUpdateRoot((DbAction.UpdateRoot)action);
                    break block14;
                }
                if (action instanceof DbAction.Update) {
                    executionContext.executeUpdate((DbAction.Update)action);
                    break block14;
                }
                if (action instanceof DbAction.Delete) {
                    executionContext.executeDelete((DbAction.Delete)action);
                    break block14;
                }
                if (action instanceof DbAction.DeleteAll) {
                    executionContext.executeDeleteAll((DbAction.DeleteAll)action);
                    break block14;
                }
                if (action instanceof DbAction.DeleteRoot) {
                    executionContext.executeDeleteRoot((DbAction.DeleteRoot)action);
                    break block14;
                }
                if (action instanceof DbAction.DeleteAllRoot) {
                    executionContext.executeDeleteAllRoot((DbAction.DeleteAllRoot)action);
                    break block14;
                }
                if (action instanceof DbAction.AcquireLockRoot) {
                    executionContext.executeAcquireLock((DbAction.AcquireLockRoot)action);
                    break block14;
                }
                if (action instanceof DbAction.AcquireLockAllRoot) {
                    executionContext.executeAcquireLockAllRoot((DbAction.AcquireLockAllRoot)action);
                    break block14;
                }
                throw new RuntimeException("unexpected action");
            }
            catch (Exception e) {
                if (e instanceof OptimisticLockingFailureException) {
                    throw e;
                }
                throw new DbActionExecutionException(action, (Throwable)e);
            }
        }
    }
}

