/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka;

import kafka.serializer.Decoder;
import kafka.serializer.Encoder;
import kafka.utils.VerifiableProperties;
import org.springframework.util.Assert;

public class IntegerEncoderDecoder
implements Encoder<Integer>,
Decoder<Integer> {
    public IntegerEncoderDecoder() {
        this(new VerifiableProperties());
    }

    public IntegerEncoderDecoder(VerifiableProperties properties) {
    }

    public Integer fromBytes(byte[] bytes) {
        Assert.isTrue((bytes.length == 4 ? 1 : 0) != 0);
        return bytes[0] << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public byte[] toBytes(Integer message) {
        int value = message;
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }
}

