/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

@Order(value=0)
public class Fabric8ConfigMapPropertySourceLocator
extends ConfigMapPropertySourceLocator {
    private final KubernetesClient client;
    private final KubernetesNamespaceProvider provider;

    @Deprecated
    public Fabric8ConfigMapPropertySourceLocator(KubernetesClient client, ConfigMapConfigProperties properties) {
        super(properties);
        this.client = client;
        this.provider = null;
    }

    public Fabric8ConfigMapPropertySourceLocator(KubernetesClient client, ConfigMapConfigProperties properties, KubernetesNamespaceProvider provider) {
        super(properties);
        this.client = client;
        this.provider = provider;
    }

    protected MapPropertySource getMapPropertySource(String applicationName, ConfigMapConfigProperties.NormalizedSource normalizedSource, String configurationTarget, ConfigurableEnvironment environment) {
        String namespace = Fabric8ConfigUtils.getApplicationNamespace(this.client, normalizedSource.getNamespace(), configurationTarget, this.provider);
        return new Fabric8ConfigMapPropertySource(this.client, applicationName, namespace, (Environment)environment, normalizedSource.getPrefix(), normalizedSource.isIncludeProfileSpecificSources(), this.properties.isFailFast());
    }
}

