/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ContractVerifierUtil {
    private static final Log LOG = LogFactory.getLog(ContractVerifierUtil.class);

    public static byte[] fileToBytes(Object testClass, String relativePath) {
        try {
            URL url = testClass.getClass().getResource(relativePath);
            if (url == null) {
                throw new FileNotFoundException(relativePath);
            }
            return Files.readAllBytes(Paths.get(url.toURI()));
        }
        catch (IOException | URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String valueFromXPath(Document parsedXml, String path) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            return xPath.evaluate(path, parsedXml.getDocumentElement());
        }
        catch (XPathExpressionException exception) {
            LOG.error((Object)("Incorrect xpath provided: " + path), (Throwable)exception);
            throw new IllegalArgumentException();
        }
    }

    public static Node nodeFromXPath(Document parsedXml, String path) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            return (Node)xPath.evaluate(path, parsedXml.getDocumentElement(), XPathConstants.NODE);
        }
        catch (XPathExpressionException exception) {
            LOG.error((Object)("Incorrect xpath provided: " + path), (Throwable)exception);
            throw new IllegalArgumentException();
        }
    }
}

