/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bus.BusBridge;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.event.AckRemoteApplicationEvent;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.context.ApplicationListener;

public class RemoteApplicationEventListener
implements ApplicationListener<RemoteApplicationEvent> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ServiceMatcher serviceMatcher;
    private final BusBridge busBridge;

    public RemoteApplicationEventListener(ServiceMatcher serviceMatcher, BusBridge busBridge) {
        this.serviceMatcher = serviceMatcher;
        this.busBridge = busBridge;
    }

    public void onApplicationEvent(RemoteApplicationEvent event) {
        if (this.serviceMatcher.isFromSelf(event) && !(event instanceof AckRemoteApplicationEvent)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending remote event on bus: " + (Object)((Object)event)));
            }
            this.busBridge.send(event);
        }
    }
}

