/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.registry;

import com.alibaba.nacos.api.naming.NamingService;
import java.net.URI;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.alibaba.nacos.NacosDiscoveryProperties;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class NacosRegistration
implements Registration,
ServiceInstance {
    public static final String MANAGEMENT_PORT = "management.port";
    public static final String MANAGEMENT_CONTEXT_PATH = "management.context-path";
    public static final String MANAGEMENT_ADDRESS = "management.address";
    public static final String MANAGEMENT_ENDPOINT_BASE_PATH = "management.endpoints.web.base-path";
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    private ApplicationContext context;

    public NacosRegistration(NacosDiscoveryProperties nacosDiscoveryProperties, ApplicationContext context) {
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.context = context;
    }

    @PostConstruct
    public void init() {
        Integer managementPort;
        Map<String, String> metadata = this.nacosDiscoveryProperties.getMetadata();
        Environment env = this.context.getEnvironment();
        String endpointBasePath = env.getProperty(MANAGEMENT_ENDPOINT_BASE_PATH);
        if (!StringUtils.isEmpty((Object)endpointBasePath)) {
            metadata.put(MANAGEMENT_ENDPOINT_BASE_PATH, endpointBasePath);
        }
        if (null != (managementPort = ManagementServerPortUtils.getPort((BeanFactory)this.context))) {
            metadata.put(MANAGEMENT_PORT, managementPort.toString());
            String contextPath = env.getProperty("management.server.servlet.context-path");
            String address = env.getProperty("management.server.address");
            if (!StringUtils.isEmpty((Object)contextPath)) {
                metadata.put(MANAGEMENT_CONTEXT_PATH, contextPath);
            }
            if (!StringUtils.isEmpty((Object)address)) {
                metadata.put(MANAGEMENT_ADDRESS, address);
            }
        }
    }

    public String getServiceId() {
        return this.nacosDiscoveryProperties.getService();
    }

    public String getHost() {
        return this.nacosDiscoveryProperties.getIp();
    }

    public int getPort() {
        return this.nacosDiscoveryProperties.getPort();
    }

    public void setPort(int port) {
        this.nacosDiscoveryProperties.setPort(port);
    }

    public boolean isSecure() {
        return this.nacosDiscoveryProperties.isSecure();
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return this.nacosDiscoveryProperties.getMetadata();
    }

    public boolean isRegisterEnabled() {
        return this.nacosDiscoveryProperties.isRegisterEnabled();
    }

    public String getCluster() {
        return this.nacosDiscoveryProperties.getClusterName();
    }

    public float getRegisterWeight() {
        return this.nacosDiscoveryProperties.getWeight();
    }

    public NacosDiscoveryProperties getNacosDiscoveryProperties() {
        return this.nacosDiscoveryProperties;
    }

    public NamingService getNacosNamingService() {
        return this.nacosDiscoveryProperties.namingServiceInstance();
    }

    public String toString() {
        return "NacosRegistration{nacosDiscoveryProperties=" + this.nacosDiscoveryProperties + '}';
    }
}

