/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.discovery;

import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alibaba.nacos.NacosDiscoveryProperties;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class NacosWatch
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(NacosWatch.class);
    private final NacosDiscoveryProperties properties;
    private final TaskScheduler taskScheduler;
    private final AtomicLong nacosWatchIndex = new AtomicLong(0L);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private ScheduledFuture<?> watchFuture;
    private Set<String> cacheServices = new HashSet<String>();
    private HashMap<String, EventListener> subscribeListeners = new HashMap();

    public NacosWatch(NacosDiscoveryProperties properties) {
        this(properties, (TaskScheduler)NacosWatch.getTaskScheduler());
    }

    public NacosWatch(NacosDiscoveryProperties properties, TaskScheduler taskScheduler) {
        this.properties = properties;
        this.taskScheduler = taskScheduler;
    }

    private static ThreadPoolTaskScheduler getTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.initialize();
        return taskScheduler;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.watchFuture = this.taskScheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    NacosWatch.this.nacosServicesWatch();
                }
            }, this.properties.getWatchDelay());
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.watchFuture != null) {
            this.watchFuture.cancel(true);
        }
    }

    public boolean isRunning() {
        return false;
    }

    public int getPhase() {
        return 0;
    }

    public void nacosServicesWatch() {
        try {
            boolean changed = false;
            NamingService namingService = this.properties.namingServiceInstance();
            ListView listView = this.properties.namingServiceInstance().getServicesOfServer(1, Integer.MAX_VALUE);
            List serviceList = listView.getData();
            HashSet currentServices = new HashSet(serviceList);
            currentServices.removeAll(this.cacheServices);
            if (currentServices.size() > 0) {
                changed = true;
            }
            if (this.cacheServices.removeAll(new HashSet(serviceList)) && this.cacheServices.size() > 0) {
                changed = true;
                for (String serviceName : this.cacheServices) {
                    namingService.unsubscribe(serviceName, this.subscribeListeners.get(serviceName));
                    this.subscribeListeners.remove(serviceName);
                }
            }
            this.cacheServices = new HashSet<String>(serviceList);
            for (String serviceName : this.cacheServices) {
                if (this.subscribeListeners.containsKey(serviceName)) continue;
                EventListener eventListener = new EventListener(){

                    public void onEvent(Event event) {
                        NacosWatch.this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)NacosWatch.this, (Object)NacosWatch.this.nacosWatchIndex.getAndIncrement()));
                    }
                };
                this.subscribeListeners.put(serviceName, eventListener);
                namingService.subscribe(serviceName, eventListener);
            }
            if (changed) {
                this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)this.nacosWatchIndex.getAndIncrement()));
            }
        }
        catch (Exception e) {
            log.error("Error watching Nacos Service change", (Throwable)e);
        }
    }
}

