/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.alibaba.nacos.NacosDiscoveryProperties;
import org.springframework.cloud.alibaba.nacos.NacosServiceInstance;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class NacosDiscoveryClient
implements DiscoveryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosDiscoveryClient.class);
    public static final String DESCRIPTION = "Spring Cloud Nacos Discovery Client";
    @Autowired
    private NacosDiscoveryProperties discoveryProperties;

    public String description() {
        return DESCRIPTION;
    }

    public ServiceInstance getLocalServiceInstance() {
        String serviceId = this.discoveryProperties.getService();
        String host = this.discoveryProperties.getIp();
        int port = this.discoveryProperties.getPort();
        boolean secure = this.discoveryProperties.isSecure();
        Map<String, String> metadata = this.discoveryProperties.getMetadata();
        return new DefaultServiceInstance(serviceId, host, port, secure, metadata);
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        try {
            List instances = this.discoveryProperties.namingServiceInstance().selectInstances(serviceId, true);
            return NacosDiscoveryClient.hostToServiceInstanceList(instances, serviceId);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get hosts from nacos server. serviceId: " + serviceId, e);
        }
    }

    private static ServiceInstance hostToServiceInstance(Instance instance, String serviceId) {
        NacosServiceInstance nacosServiceInstance = new NacosServiceInstance();
        nacosServiceInstance.setHost(instance.getIp());
        nacosServiceInstance.setPort(instance.getPort());
        nacosServiceInstance.setServiceId(serviceId);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("instanceId", instance.getInstanceId());
        metadata.put("weight", instance.getWeight() + "");
        metadata.put("healthy", instance.isHealthy() + "");
        metadata.put("cluster", instance.getClusterName() + "");
        metadata.putAll(instance.getMetadata());
        nacosServiceInstance.setMetadata(metadata);
        return nacosServiceInstance;
    }

    private static List<ServiceInstance> hostToServiceInstanceList(List<Instance> instances, String serviceId) {
        ArrayList<ServiceInstance> result = new ArrayList<ServiceInstance>(instances.size());
        for (Instance instance : instances) {
            result.add(NacosDiscoveryClient.hostToServiceInstance(instance, serviceId));
        }
        return result;
    }

    public List<String> getServices() {
        try {
            ListView services = this.discoveryProperties.namingServiceInstance().getServicesOfServer(1, Integer.MAX_VALUE);
            return services.getData();
        }
        catch (Exception e) {
            LOGGER.error("get service name from nacos server fail,", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

