/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.endpoint;

import com.alibaba.nacos.api.naming.NamingService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.cloud.alibaba.nacos.NacosDiscoveryProperties;

public class NacosDiscoveryEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosDiscoveryEndpoint.class);
    @Autowired
    private NacosDiscoveryProperties nacosDiscoveryProperties;

    public NacosDiscoveryEndpoint() {
        super("nacos_discovery", false);
    }

    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("NacosDiscoveryProperties", this.nacosDiscoveryProperties);
        NamingService namingService = this.nacosDiscoveryProperties.namingServiceInstance();
        List subscribe = Collections.emptyList();
        try {
            subscribe = namingService.getSubscribeServices();
        }
        catch (Exception e) {
            LOGGER.error("get subscribe services from nacos fail,", (Throwable)e);
        }
        result.put("subscribe", subscribe);
        return result;
    }
}

