/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.pulsar;

import org.springframework.boot.autoconfigure.pulsar.PulsarConnectionDetails;
import org.springframework.boot.docker.compose.core.ConnectionPorts;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class PulsarDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<PulsarConnectionDetails> {
    private static final int BROKER_PORT = 6650;
    private static final int ADMIN_PORT = 8080;

    PulsarDockerComposeConnectionDetailsFactory() {
        super("apachepulsar/pulsar", new String[0]);
    }

    @Override
    protected PulsarConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new PulsarDockerComposeConnectionDetails(source.getRunningService());
    }

    static class PulsarDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements PulsarConnectionDetails {
        private final String brokerUrl;
        private final String adminUrl;

        PulsarDockerComposeConnectionDetails(RunningService service) {
            super(service);
            ConnectionPorts ports = service.ports();
            this.brokerUrl = "pulsar://%s:%s".formatted(service.host(), ports.get(6650));
            this.adminUrl = "http://%s:%s".formatted(service.host(), ports.get(8080));
        }

        public String getBrokerUrl() {
            return this.brokerUrl;
        }

        public String getAdminUrl() {
            return this.adminUrl;
        }
    }
}

