/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.minimax;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.minimax.MiniMaxChatOptions;
import org.springframework.ai.minimax.api.MiniMaxApi;
import org.springframework.ai.minimax.api.MiniMaxApiConstants;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.model.tool.internal.ToolCallReactiveContextHolder;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.ContextView;

public class MiniMaxChatModel
implements ChatModel {
    private static final Logger logger = LoggerFactory.getLogger(MiniMaxChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    public final RetryTemplate retryTemplate;
    private final MiniMaxChatOptions defaultOptions;
    private final MiniMaxApi miniMaxApi;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public MiniMaxChatModel(MiniMaxApi miniMaxApi) {
        this(miniMaxApi, MiniMaxChatOptions.builder().model(MiniMaxApi.DEFAULT_CHAT_MODEL).temperature(0.7).build());
    }

    public MiniMaxChatModel(MiniMaxApi miniMaxApi, MiniMaxChatOptions options) {
        this(miniMaxApi, options, (ToolCallingManager)ToolCallingManager.builder().build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public MiniMaxChatModel(MiniMaxApi miniMaxApi, MiniMaxChatOptions options, ToolCallingManager toolCallingManager) {
        this(miniMaxApi, options, toolCallingManager, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public MiniMaxChatModel(MiniMaxApi miniMaxApi, MiniMaxChatOptions options, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate) {
        this(miniMaxApi, options, toolCallingManager, retryTemplate, ObservationRegistry.NOOP, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public MiniMaxChatModel(MiniMaxApi miniMaxApi, MiniMaxChatOptions options, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        Assert.notNull((Object)miniMaxApi, (String)"MiniMaxApi must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull((Object)toolCallingManager, (String)"toolCallingManager cannot be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        Assert.notNull((Object)toolExecutionEligibilityPredicate, (String)"toolExecutionEligibilityPredicate cannot be null");
        this.miniMaxApi = miniMaxApi;
        this.defaultOptions = options;
        this.toolCallingManager = toolCallingManager;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
        this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
    }

    private static Generation buildGeneration(MiniMaxApi.ChatCompletion.Choice choice, Map<String, Object> metadata) {
        List toolCalls = choice.message().toolCalls() == null ? List.of() : (List)choice.message().toolCalls().stream().reduce(new ArrayList(), (acc, current) -> {
            if (!acc.isEmpty() && current.id().isEmpty()) {
                AssistantMessage.ToolCall prev = (AssistantMessage.ToolCall)acc.get(acc.size() - 1);
                acc.set(acc.size() - 1, new AssistantMessage.ToolCall(prev.id(), prev.type(), prev.name(), current.function().arguments()));
            } else {
                AssistantMessage.ToolCall currentToolCall = new AssistantMessage.ToolCall(current.id(), current.type(), current.function().name(), current.function().arguments());
                acc.add(currentToolCall);
            }
            return acc;
        }, (acc1, acc2) -> {
            acc1.addAll(acc2);
            return acc1;
        });
        AssistantMessage assistantMessage = new AssistantMessage(choice.message().content(), metadata, toolCalls);
        String finishReason = choice.finishReason() != null ? choice.finishReason().name() : "";
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.builder().finishReason(finishReason).build();
        return new Generation(assistantMessage, generationMetadata);
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        MiniMaxApi.ChatCompletionRequest request = this.createRequest(requestPrompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(requestPrompt).provider(MiniMaxApiConstants.PROVIDER_NAME).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.miniMaxApi.chatCompletionEntity(request));
            MiniMaxApi.ChatCompletion chatCompletion = (MiniMaxApi.ChatCompletion)completionEntity.getBody();
            if (chatCompletion == null) {
                logger.warn("No chat completion returned for prompt: {}", (Object)requestPrompt);
                return new ChatResponse(List.of());
            }
            List<MiniMaxApi.ChatCompletion.Choice> choices = chatCompletion.choices();
            if (choices == null) {
                logger.warn("No choices returned for prompt: {}, because: {}}", (Object)requestPrompt, (Object)chatCompletion.baseResponse().message());
                return new ChatResponse(List.of());
            }
            List<Generation> generations = choices.stream().map(choice -> {
                MiniMaxApi.ChatCompletionMessage message = null;
                if (choice.message() != null) {
                    message = choice.message();
                } else if (!CollectionUtils.isEmpty(choice.messages())) {
                    message = choice.messages().get(choice.messages().size() - 1);
                }
                Map<String, Object> metadata = Map.of("id", chatCompletion.id(), "role", message != null && message.role() != null ? message.role().name() : "", "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                return this.buildGeneration(message, choice.finishReason(), metadata);
            }).toList();
            ChatResponse chatResponse = new ChatResponse(generations, this.from((MiniMaxApi.ChatCompletion)completionEntity.getBody()));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(requestPrompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(requestPrompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.call(new Prompt(toolExecutionResult.conversationHistory(), requestPrompt.getOptions()));
        }
        return response;
    }

    public ChatOptions getDefaultOptions() {
        return MiniMaxChatOptions.fromOptions(this.defaultOptions);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return Flux.deferContextual(contextView -> {
            MiniMaxApi.ChatCompletionRequest request = this.createRequest(requestPrompt, true);
            Flux completionChunks = (Flux)this.retryTemplate.execute(ctx -> this.miniMaxApi.chatCompletionStream(request));
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(requestPrompt).provider(MiniMaxApiConstants.PROVIDER_NAME).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux chatResponse = completionChunks.map(this::chunkToChatCompletion).switchMap(chatCompletion -> Mono.just((Object)chatCompletion).map(chatCompletion2 -> {
                try {
                    String id = chatCompletion2.id();
                    List<Generation> generations = chatCompletion2.choices().stream().map(choice -> {
                        if (choice.message().role() != null) {
                            roleMap.putIfAbsent(id, choice.message().role().name());
                        }
                        Map<String, Object> metadata = Map.of("id", chatCompletion2.id(), "role", roleMap.getOrDefault(id, ""), "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                        return MiniMaxChatModel.buildGeneration(choice, metadata);
                    }).toList();
                    return new ChatResponse(generations, this.from((MiniMaxApi.ChatCompletion)chatCompletion2));
                }
                catch (Exception e) {
                    logger.error("Error processing chat completion", (Throwable)e);
                    return new ChatResponse(List.of());
                }
            }));
            Flux flux = chatResponse.flatMap(response -> {
                if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(requestPrompt.getOptions(), response)) {
                    return Flux.deferContextual(ctx -> {
                        ToolExecutionResult toolExecutionResult;
                        try {
                            ToolCallReactiveContextHolder.setContext((ContextView)ctx);
                            toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
                        }
                        finally {
                            ToolCallReactiveContextHolder.clearContext();
                        }
                        if (toolExecutionResult.returnDirect()) {
                            return Flux.just((Object)ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                        }
                        return this.stream(new Prompt(toolExecutionResult.conversationHistory(), requestPrompt.getOptions()));
                    }).subscribeOn(Schedulers.boundedElastic());
                }
                return Flux.just((Object)response);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(signalType -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private ChatResponseMetadata from(MiniMaxApi.ChatCompletion result) {
        Assert.notNull((Object)result, (String)"MiniMax ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.id() != null ? result.id() : "").usage((Usage)(result.usage() != null ? this.getDefaultUsage(result.usage()) : new EmptyUsage())).model(result.model() != null ? result.model() : "").keyValue("created", (Object)(result.created() != null ? result.created() : 0L)).keyValue("system-fingerprint", (Object)(result.systemFingerprint() != null ? result.systemFingerprint() : "")).build();
    }

    private DefaultUsage getDefaultUsage(MiniMaxApi.Usage usage) {
        return new DefaultUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens(), (Object)usage);
    }

    private Generation buildGeneration(MiniMaxApi.ChatCompletionMessage message, MiniMaxApi.ChatCompletionFinishReason completionFinishReason, Map<String, Object> metadata) {
        if (message == null || message.role() == MiniMaxApi.ChatCompletionMessage.Role.TOOL) {
            return null;
        }
        List toolCalls = message.toolCalls() == null ? List.of() : message.toolCalls().stream().map(toolCall -> new AssistantMessage.ToolCall(toolCall.id(), toolCall.type(), toolCall.function().name(), toolCall.function().arguments())).toList();
        AssistantMessage assistantMessage = new AssistantMessage(message.content(), metadata, toolCalls);
        String finishReason = completionFinishReason != null ? completionFinishReason.name() : "";
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.builder().finishReason(finishReason).build();
        return new Generation(assistantMessage, generationMetadata);
    }

    private MiniMaxApi.ChatCompletion chunkToChatCompletion(MiniMaxApi.ChatCompletionChunk chunk) {
        List<MiniMaxApi.ChatCompletion.Choice> choices = chunk.choices().stream().map(cc -> {
            MiniMaxApi.ChatCompletionMessage delta = cc.delta();
            if (delta == null) {
                delta = new MiniMaxApi.ChatCompletionMessage("", MiniMaxApi.ChatCompletionMessage.Role.ASSISTANT);
            }
            return new MiniMaxApi.ChatCompletion.Choice(cc.finishReason(), cc.index(), delta, null, cc.logprobs());
        }).toList();
        return new MiniMaxApi.ChatCompletion(chunk.id(), choices, chunk.created(), chunk.model(), chunk.systemFingerprint(), "chat.completion", null, null);
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        MiniMaxChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (MiniMaxChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, MiniMaxChatOptions.class);
            } else {
                runtimeOptions = (MiniMaxChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, MiniMaxChatOptions.class);
            }
        }
        MiniMaxChatOptions requestOptions = (MiniMaxChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, MiniMaxChatOptions.class);
        if (runtimeOptions != null) {
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getInternalToolExecutionEnabled(), (Object)this.defaultOptions.getInternalToolExecutionEnabled()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.getInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    MiniMaxApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        List<MiniMaxApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(message -> {
            if (message.getMessageType() == MessageType.USER || message.getMessageType() == MessageType.SYSTEM) {
                String content = message.getText();
                return List.of(new MiniMaxApi.ChatCompletionMessage(content, MiniMaxApi.ChatCompletionMessage.Role.valueOf(message.getMessageType().name())));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<MiniMaxApi.ChatCompletionMessage.ToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        MiniMaxApi.ChatCompletionMessage.ChatCompletionFunction function = new MiniMaxApi.ChatCompletionMessage.ChatCompletionFunction(toolCall.name(), toolCall.arguments());
                        return new MiniMaxApi.ChatCompletionMessage.ToolCall(toolCall.id(), toolCall.type(), function);
                    }).toList();
                }
                return List.of(new MiniMaxApi.ChatCompletionMessage(assistantMessage.getText(), MiniMaxApi.ChatCompletionMessage.Role.ASSISTANT, null, null, toolCalls));
            }
            if (message.getMessageType() == MessageType.TOOL) {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                toolMessage.getResponses().forEach(response -> Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id"));
                return toolMessage.getResponses().stream().map(tr -> new MiniMaxApi.ChatCompletionMessage(tr.responseData(), MiniMaxApi.ChatCompletionMessage.Role.TOOL, tr.name(), tr.id(), null)).toList();
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.getMessageType()));
        }).flatMap(Collection::stream).toList();
        MiniMaxApi.ChatCompletionRequest request = new MiniMaxApi.ChatCompletionRequest(chatCompletionMessages, stream);
        MiniMaxChatOptions requestOptions = (MiniMaxChatOptions)prompt.getOptions();
        request = (MiniMaxApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)requestOptions, (Object)request, MiniMaxApi.ChatCompletionRequest.class);
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            request = (MiniMaxApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)MiniMaxChatOptions.builder().tools(this.getFunctionTools(toolDefinitions)).build(), (Object)request, MiniMaxApi.ChatCompletionRequest.class);
        }
        if (prompt.getOptions() != null) {
            MiniMaxChatOptions updatedRuntimeOptions;
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                updatedRuntimeOptions = (MiniMaxChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, MiniMaxChatOptions.class);
            } else {
                updatedRuntimeOptions = (MiniMaxChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, MiniMaxChatOptions.class);
            }
            request = (MiniMaxApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, MiniMaxApi.ChatCompletionRequest.class);
        }
        request = (MiniMaxApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, MiniMaxApi.ChatCompletionRequest.class);
        return request;
    }

    private List<MiniMaxApi.FunctionTool> getFunctionTools(List<ToolDefinition> toolDefinitions) {
        return toolDefinitions.stream().map(toolDefinition -> {
            MiniMaxApi.FunctionTool.Function function = new MiniMaxApi.FunctionTool.Function(toolDefinition.description(), toolDefinition.name(), toolDefinition.inputSchema());
            return new MiniMaxApi.FunctionTool(function);
        }).toList();
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }
}

