/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class Issue {
    private final String key;
    private final String componentKey;
    private final String message;
    private final String ruleKey;
    private final String ruleName;
    private final String status;
    private final String resolution;
    private final boolean isNew;
    private final String assigneeLogin;
    private final String assigneeName;
    private final String severity;
    private final Integer startLine;
    private final Integer startLineOffset;
    private final Integer endLine;
    private final Integer endLineOffset;

    private Issue(String key, String componentKey, String message, String ruleKey, String ruleName, String status, String resolution, boolean isNew, String assigneeLogin, String assigneeName, String severity, Integer startLine, Integer startLineOffset, Integer endLine, Integer endLineOffset) {
        this.key = key;
        this.componentKey = componentKey;
        this.message = message;
        this.ruleKey = ruleKey;
        this.ruleName = ruleName;
        this.status = status;
        this.resolution = resolution;
        this.isNew = isNew;
        this.assigneeLogin = assigneeLogin;
        this.assigneeName = assigneeName;
        this.severity = severity;
        this.startLine = startLine;
        this.startLineOffset = startLineOffset;
        this.endLine = endLine;
        this.endLineOffset = endLineOffset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKey() {
        return this.key;
    }

    public String getComponentKey() {
        return this.componentKey;
    }

    public Integer getStartLine() {
        return this.startLine;
    }

    public Integer getStartLineOffset() {
        return this.startLineOffset;
    }

    public Integer getEndLine() {
        return this.endLine;
    }

    public Integer getEndLineOffset() {
        return this.endLineOffset;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRuleKey() {
        return this.ruleKey;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResolution() {
        return this.resolution;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getAssigneeLogin() {
        return this.assigneeLogin;
    }

    public String getAssigneeName() {
        return this.assigneeName;
    }

    public String getSeverity() {
        return this.severity;
    }

    public static class Builder {
        private String key;
        private String componentKey;
        private String message;
        private String ruleKey;
        private String ruleName;
        private String status;
        private String resolution;
        private boolean isNew;
        private String assigneeLogin;
        private String assigneeName;
        private String severity;
        private Integer startLine;
        private Integer startLineOffset;
        private Integer endLine;
        private Integer endLineOffset;

        public Builder setStartLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        public Builder setStartLineOffset(Integer startLineOffset) {
            this.startLineOffset = startLineOffset;
            return this;
        }

        public Builder setEndLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public Builder setEndLineOffset(Integer endLineOffset) {
            this.endLineOffset = endLineOffset;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setComponentKey(String componentKey) {
            this.componentKey = componentKey;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setRuleKey(String ruleKey) {
            this.ruleKey = ruleKey;
            return this;
        }

        public Builder setRuleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder setResolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder setNew(boolean isNew) {
            this.isNew = isNew;
            return this;
        }

        public Builder setAssigneeLogin(String assigneeLogin) {
            this.assigneeLogin = assigneeLogin;
            return this;
        }

        public Builder setAssigneeName(String assigneeName) {
            this.assigneeName = assigneeName;
            return this;
        }

        public Builder setSeverity(String severity) {
            this.severity = severity;
            return this;
        }

        public Issue build() {
            return new Issue(this.key, this.componentKey, this.message, this.ruleKey, this.ruleName, this.status, this.resolution, this.isNew, this.assigneeLogin, this.assigneeName, this.severity, this.startLine, this.startLineOffset, this.endLine, this.endLineOffset);
        }
    }
}

