/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.slf4j.Marker;
import org.slf4j.MarkingLogger;
import org.slf4j.impl.MessageFormatter;

public class SimpleLogger
implements MarkingLogger {
    private static long startTime = System.currentTimeMillis();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String INFO_STR = "INFO";
    private static String WARN_STR = "WARN";
    private static String ERROR_STR = "ERROR";
    String name;

    SimpleLogger(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public boolean isDebugEnabled(Marker marker) {
        return false;
    }

    public void debug(String msg) {
    }

    public void debug(String format, Object param1) {
    }

    public void debug(String format, Object param1, Object param2) {
    }

    public void debug(String msg, Throwable t) {
    }

    public void debug(Marker marker, String msg) {
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    private void log(String level, String message, Throwable t) {
        StringBuffer buf = new StringBuffer();
        long millis = System.currentTimeMillis();
        buf.append(millis - startTime);
        buf.append(" [");
        buf.append(Thread.currentThread().getName());
        buf.append("] ");
        buf.append(level);
        buf.append(" ");
        buf.append(this.name);
        buf.append(" - ");
        buf.append(message);
        buf.append(LINE_SEPARATOR);
        System.out.print(buf.toString());
        if (t != null) {
            t.printStackTrace(System.out);
        }
        System.out.flush();
    }

    private void formatAndLog(String level, String format, Object arg1, Object arg2) {
        String message = MessageFormatter.format(format, arg1, arg2);
        this.log(level, message, null);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    public void info(String msg) {
        this.log(INFO_STR, msg, null);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(INFO_STR, format, arg, null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(INFO_STR, format, arg1, arg2);
    }

    public void info(String msg, Throwable t) {
        this.log(INFO_STR, msg.toString(), t);
    }

    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void warn(String msg) {
        this.log(WARN_STR, msg.toString(), null);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(WARN_STR, format, arg, null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(WARN_STR, format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.log(WARN_STR, msg.toString(), t);
    }

    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public void error(String msg) {
        this.log(ERROR_STR, msg.toString(), null);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(ERROR_STR, format, arg, null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(ERROR_STR, format, arg1, arg2);
    }

    public void error(String msg, Throwable t) {
        this.log(ERROR_STR, msg.toString(), t);
    }

    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }
}

