/*
 * Decompiled with CFR 0.152.
 */
package org.phprpc.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Random;
import org.phprpc.util.Cast;
import org.phprpc.util.PHPSerializer;

public final class DHParams {
    private int length;
    private HashMap dhParams;
    private static final int[] lengths = new int[]{96, 128, 160, 192, 256, 512, 768, 1024, 1536, 2048, 3072, 4096};
    private static final HashMap dhParamsGen = new HashMap();

    private static byte[] getBinaryFileFromJar(String path) throws IOException {
        InputStream is = DHParams.class.getResourceAsStream(path);
        if (is != null) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            byte[] bytes = new byte[4096];
            int read = 0;
            while ((read = is.read(bytes)) >= 0) {
                bs.write(bytes, 0, read);
            }
            return bs.toByteArray();
        }
        return null;
    }

    public static int getNearest(int n) {
        int j = 0;
        int m = Math.abs(lengths[0] - n);
        for (int i = 1; i < lengths.length; ++i) {
            int t = Math.abs(lengths[i] - n);
            if (m <= t) continue;
            m = t;
            j = i;
        }
        return lengths[j];
    }

    public static HashMap getDHParams(int len) {
        HashMap[] dhParams = (HashMap[])dhParamsGen.get(new Integer(len));
        return dhParams[(int)Math.floor(Math.random() * (double)dhParams.length)];
    }

    public DHParams(int len) {
        this.length = DHParams.getNearest(len);
        this.dhParams = DHParams.getDHParams(this.length);
    }

    public int getL() {
        return this.length;
    }

    public BigInteger getP() {
        return new BigInteger(Cast.toString(this.dhParams.get("p")));
    }

    public BigInteger getG() {
        return new BigInteger(Cast.toString(this.dhParams.get("g")));
    }

    public BigInteger getX() {
        return new BigInteger(this.length - 1, new Random()).setBit(this.length - 2);
    }

    public HashMap getDHParams() {
        return this.dhParams;
    }

    static {
        try {
            PHPSerializer phpser = new PHPSerializer();
            int n = lengths.length;
            for (int i = 0; i < n; ++i) {
                String path = "/dhparams/" + lengths[i] + ".dhp";
                byte[] data = DHParams.getBinaryFileFromJar(path);
                HashMap[] dhParams = (HashMap[])phpser.unserialize(data, HashMap[].class);
                dhParamsGen.put(new Integer(lengths[i]), dhParams);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

