/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials;

import java.util.List;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameID;
import org.pac4j.core.credentials.Credentials;

public class SAML2Credentials
extends Credentials {
    private static final long serialVersionUID = 5040516205957826527L;
    private NameID nameId;
    private String sessionIndex;
    private List<Attribute> attributes;
    private Conditions conditions;
    private String issuerId;
    private List<String> authnContexts;

    public SAML2Credentials(NameID nameId, String issuerId, List<Attribute> attributes, Conditions conditions, String clientName, String sessionIndex, List<String> authnContexts) {
        this.nameId = nameId;
        this.issuerId = issuerId;
        this.sessionIndex = sessionIndex;
        this.attributes = attributes;
        this.conditions = conditions;
        this.authnContexts = authnContexts;
        this.setClientName(clientName);
    }

    public final NameID getNameId() {
        return this.nameId;
    }

    public final String getSessionIndex() {
        return this.sessionIndex;
    }

    public final List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SAML2Credentials that = (SAML2Credentials)((Object)o);
        if (this.nameId != null ? !this.nameId.equals(that.nameId) : that.nameId != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.sessionIndex != null ? this.sessionIndex.equals(that.sessionIndex) : that.sessionIndex != null) {
            return false;
        }
        return !(this.conditions == null ? that.conditions != null : !this.conditions.equals(that.conditions));
    }

    public int hashCode() {
        int result = this.nameId != null ? this.nameId.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + (this.sessionIndex != null ? this.sessionIndex.hashCode() : 0);
        result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
        return result;
    }

    public final String toString() {
        return "SAMLCredential [nameId=" + this.nameId + ", attributes=" + this.attributes + ", sessionIndex=" + this.sessionIndex + "]";
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public List<String> getAuthnContexts() {
        return this.authnContexts;
    }
}

