/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.authenticator;

import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.profile.CasProfileDefinition;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticator
extends ProfileDefinitionAware<CommonProfile>
implements Authenticator<TokenCredentials> {
    private static final Logger logger = LoggerFactory.getLogger(CasAuthenticator.class);
    private CasConfiguration configuration;
    private String callbackUrl;

    public CasAuthenticator() {
    }

    public CasAuthenticator(CasConfiguration configuration, String callbackUrl) {
        this.configuration = configuration;
        this.callbackUrl = callbackUrl;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(context);
        this.defaultProfileDefinition((ProfileDefinition)new CasProfileDefinition());
    }

    public void validate(TokenCredentials credentials, WebContext context) throws HttpAction {
        this.init(context);
        String ticket = credentials.getToken();
        try {
            CommonProfile profile;
            String finalCallbackUrl = this.configuration.computeFinalUrl(this.callbackUrl, context);
            Assertion assertion = this.configuration.retrieveTicketValidator(context).validate(ticket, finalCallbackUrl);
            AttributePrincipal principal = assertion.getPrincipal();
            logger.debug("principal: {}", (Object)principal);
            String id = principal.getName();
            HashMap<String, Object> newAttributes = new HashMap<String, Object>();
            Map attributes = principal.getAttributes();
            if (attributes != null) {
                for (Map.Entry entry : attributes.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    Object restored = ProfileHelper.getInternalAttributeHandler().restore(value);
                    newAttributes.put(key, restored);
                }
            }
            if (this.configuration.getProxyReceptor() != null) {
                profile = this.getProfileDefinition().newProfile(new Object[]{principal, this.configuration.getProxyReceptor()});
                profile.setId((Object)id);
                this.getProfileDefinition().convertAndAdd(profile, newAttributes);
            } else {
                profile = ProfileHelper.restoreOrBuildProfile((ProfileDefinition)this.getProfileDefinition(), (String)id, newAttributes, (Object[])new Object[]{principal, this.configuration.getProxyReceptor()});
            }
            logger.debug("profile returned by CAS: {}", (Object)profile);
            credentials.setUserProfile(profile);
        }
        catch (TicketValidationException e) {
            String message = "cannot validate CAS ticket: " + ticket;
            throw new TechnicalException(message, (Throwable)e);
        }
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }
}

