/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.options;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.ConfigurationPointer;
import org.ops4j.pax.exam.karaf.options.DoNotModifyLogOption;
import org.ops4j.pax.exam.karaf.options.ExamBundlesStartLevel;
import org.ops4j.pax.exam.karaf.options.KarafDistributionBaseConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationConsoleOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationFileExtendOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationFilePutOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationFileReplacementOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationSecurityOption;
import org.ops4j.pax.exam.karaf.options.KarafExamSystemConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafFeaturesOption;
import org.ops4j.pax.exam.karaf.options.KeepRuntimeFolderOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.extra.VMOption;

public final class KarafDistributionOption {
    private KarafDistributionOption() {
    }

    public static Option keepRuntimeFolder() {
        return new KeepRuntimeFolderOption();
    }

    public static Option useOwnKarafExamSystemConfiguration(String invoker) {
        return new KarafExamSystemConfigurationOption(invoker);
    }

    public static Option doNotModifyLogConfiguration() {
        return new DoNotModifyLogOption();
    }

    public static Option useOwnExamBundlesStartLevel(int startLevel) {
        return new ExamBundlesStartLevel(startLevel);
    }

    public static KarafDistributionConfigurationConsoleOption configureConsole() {
        return new KarafDistributionConfigurationConsoleOption(null, null);
    }

    public static KarafDistributionConfigurationSecurityOption configureSecurity() {
        return new KarafDistributionConfigurationSecurityOption(null);
    }

    public static KarafDistributionBaseConfigurationOption karafDistributionConfiguration(String frameworkURL, String name, String karafVersion) {
        return new KarafDistributionConfigurationOption(frameworkURL, name, karafVersion);
    }

    public static KarafDistributionBaseConfigurationOption karafDistributionConfiguration() {
        return new KarafDistributionConfigurationOption();
    }

    public static Option editConfigurationFilePut(String configurationFilePath, String key, String value) {
        return new KarafDistributionConfigurationFilePutOption(configurationFilePath, key, value);
    }

    public static Option editConfigurationFilePut(ConfigurationPointer configurationPointer, String value) {
        return new KarafDistributionConfigurationFilePutOption(configurationPointer, value);
    }

    public static Option[] editConfigurationFilePut(final String configurationFilePath, File source, String ... keysToUseFromSource) {
        return KarafDistributionOption.createOptionListFromFile(source, new FileOptionFactory(){

            @Override
            public Option createOption(String key, String value) {
                return new KarafDistributionConfigurationFilePutOption(configurationFilePath, key, value);
            }
        }, keysToUseFromSource);
    }

    private static Option[] createOptionListFromFile(File source, FileOptionFactory optionFactory, String ... keysToUseFromSource) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(source));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        ArrayList<Option> options = new ArrayList<Option>();
        if (keysToUseFromSource == null || keysToUseFromSource.length == 0) {
            Set<Object> keySet = props.keySet();
            for (Object key : keySet) {
                Object value = props.get(key);
                options.add(optionFactory.createOption((String)key, (String)value));
            }
        } else {
            for (String key : keysToUseFromSource) {
                Object value = props.get(key);
                options.add(optionFactory.createOption(key, (String)value));
            }
        }
        return options.toArray(new Option[0]);
    }

    public static Option editConfigurationFileExtend(String configurationFilePath, String key, String value) {
        return new KarafDistributionConfigurationFileExtendOption(configurationFilePath, key, value);
    }

    public static Option editConfigurationFileExtend(ConfigurationPointer configurationPointer, String value) {
        return new KarafDistributionConfigurationFileExtendOption(configurationPointer, value);
    }

    public static Option[] editConfigurationFileExtend(final String configurationFilePath, File source, String ... keysToUseFromSource) {
        return KarafDistributionOption.createOptionListFromFile(source, new FileOptionFactory(){

            @Override
            public Option createOption(String key, String value) {
                return new KarafDistributionConfigurationFileExtendOption(configurationFilePath, key, value);
            }
        }, keysToUseFromSource);
    }

    public static Option replaceConfigurationFile(String configurationFilePath, File source) {
        return new KarafDistributionConfigurationFileReplacementOption(configurationFilePath, source);
    }

    public static Option debugConfiguration() {
        return KarafDistributionOption.debugConfiguration("5005", true);
    }

    public static Option logLevel(LogLevelOption.LogLevel logLevel) {
        return new LogLevelOption(logLevel);
    }

    public static LogLevelOption logLevel() {
        return new LogLevelOption();
    }

    public static Option debugConfiguration(String port, boolean hold) {
        return new VMOption(String.format("-Xrunjdwp:transport=dt_socket,server=y,suspend=%s,address=%s", hold ? "y" : "n", port));
    }

    public static KarafFeaturesOption features(String repositoryUrl, String ... features) {
        return new KarafFeaturesOption(repositoryUrl, features);
    }

    public static KarafFeaturesOption features(UrlReference repositoryUrl, String ... features) {
        return new KarafFeaturesOption(repositoryUrl, features);
    }

    private static interface FileOptionFactory {
        public Option createOption(String var1, String var2);
    }
}

