/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import rpc.ProviderException;
import rpc.Transport;

public abstract class TransportFactory {
    private static Properties defaultProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getDefaultProperties() {
        Class<TransportFactory> clazz = TransportFactory.class;
        synchronized (TransportFactory.class) {
            if (defaultProperties == null) {
                Properties properties = new Properties();
                String defaults = null;
                try {
                    defaults = System.getProperty("rpc.properties");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (defaults != null) {
                    URL url = null;
                    try {
                        url = new URL(new File(".").toURL(), defaults);
                        properties.load(url.openStream());
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalArgumentException("Bad location " + defaults + ": " + ex.getMessage());
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Unable to load  RPC properties from " + url + ": " + ex.getMessage());
                    }
                }
                try {
                    properties.load(TransportFactory.class.getResourceAsStream("/rpc.properties"));
                }
                catch (Exception ex) {
                    try {
                        properties.load(ClassLoader.getSystemResourceAsStream("/rpc.properties"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                defaultProperties = properties;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Properties properties = new Properties(defaultProperties);
            try {
                properties.putAll((Map<?, ?>)System.getProperties());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return properties;
        }
    }

    public abstract Transport createTransport(String var1, Properties var2) throws ProviderException;
}

