/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly;

import edu.mit.simile.butterfly.ButterflyModule;
import edu.mit.simile.butterfly.ButterflyScriptableObject;
import edu.mit.simile.butterfly.ScriptableButterfly;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButterflyScope
extends ScriptableObject {
    private static final long serialVersionUID = -7468104001568307817L;
    protected static final Logger _logger = LoggerFactory.getLogger((String)"butterfly.scope");

    public ButterflyScope(ButterflyModule module, Context context) throws Exception {
        _logger.trace("> new ButterflyScope for module: {}", (Object)module.getName());
        ImporterTopLevel scope = new ImporterTopLevel(context);
        ButterflyScope.defineClass((Scriptable)scope, ScriptableButterfly.class);
        this.setPrototype((Scriptable)scope);
        this.setParentScope(null);
        Object[] args = new Object[]{};
        ScriptableButterfly _scriptableButterfly = (ScriptableButterfly)context.newObject((Scriptable)this, ScriptableButterfly.getName(), args);
        _scriptableButterfly.init(module);
        _scriptableButterfly.setParentScope((Scriptable)this);
        super.put("butterfly", (Scriptable)this, (Object)_scriptableButterfly);
        super.put("module", (Scriptable)this, (Object)module);
        this.prepareScope(context, (Scriptable)scope, module);
        _logger.trace("< new ButterflyScope for module: {}", (Object)module.getName());
    }

    private void prepareScope(Context context, Scriptable scope, ButterflyModule module) throws Exception {
        _logger.trace("> prepareScope({})", (Object)module.getName());
        Map<String, ButterflyModule> dependencies = module.getDependencies();
        for (ButterflyModule m : dependencies.values()) {
            this.prepareScope(context, scope, m);
        }
        Set<ButterflyScriptableObject> scriptables = module.getScriptables();
        Object[] args = new Object[]{};
        for (ButterflyScriptableObject c : scriptables) {
            ButterflyScope.defineClass((Scriptable)scope, ((Object)((Object)c)).getClass());
            _logger.debug("defined class: {}", (Object)c.getClassName());
            ButterflyScriptableObject scriptable = (ButterflyScriptableObject)context.newObject((Scriptable)this, c.getClassName(), args);
            scriptable.init(module);
            scriptable.setParentScope((Scriptable)this);
            Set<String> implementations = module.getImplementations();
            for (String name : implementations) {
                super.put(name, (Scriptable)this, (Object)scriptable);
                _logger.debug("defined instance: {}", (Object)name);
            }
        }
        _logger.trace("< prepareScope({})", (Object)module.getName());
    }

    public String getClassName() {
        return "ButterflyScope";
    }
}

