/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.Map;

public class CompatibleOracleJdkHandler {
    private static Map<Provider, Object> verificationResults;
    private static Class<?> jceSecurityClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void skipJarVerify(Provider provider) {
        if (jceSecurityClass != null && verificationResults != null) {
            Class<?> clazz = jceSecurityClass;
            synchronized (clazz) {
                verificationResults.put(provider, Boolean.TRUE);
            }
        }
    }

    private static void init() {
        if (!CompatibleOracleJdkHandler.isOracleJdk()) {
            return;
        }
        try {
            jceSecurityClass = Class.forName("javax.crypto.JceSecurity");
            Field verificationResultsField = jceSecurityClass.getDeclaredField("verificationResults");
            verificationResultsField.setAccessible(true);
            Object object = verificationResultsField.get(null);
            if (object instanceof Map) {
                verificationResults = (Map)object;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static boolean isOracleJdk() {
        String vendor = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.vendor");
            }
        });
        return vendor != null && vendor.startsWith("Oracle");
    }

    static {
        CompatibleOracleJdkHandler.init();
    }
}

