/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.util.ClassUtil;

public class DsUtils {
    private static Class<?> resolveType(Properties props) {
        String typeStr = props.getProperty("type");
        if (Utils.isEmpty((String)typeStr)) {
            throw new IllegalStateException("Missing type configuration");
        }
        props.remove("type");
        Class typeClz = ClassUtil.loadClass((String)typeStr);
        if (typeClz == null || !DataSource.class.isAssignableFrom(typeClz)) {
            throw new IllegalStateException("Type configuration not is data source");
        }
        return typeClz;
    }

    private static Class<?> resolveTypeOrDefault(Properties props, Class<?> typeDef) {
        String typeStr = props.getProperty("type");
        if (Utils.isEmpty((String)typeStr)) {
            return typeDef;
        }
        props.remove("type");
        Class typeClz = ClassUtil.loadClass((String)typeStr);
        if (typeClz == null || !DataSource.class.isAssignableFrom(typeClz)) {
            throw new IllegalStateException("Type configuration not is data source");
        }
        return typeClz;
    }

    public static DataSource buildDs(Properties props) {
        Class<?> typeClz = DsUtils.resolveType(props);
        return DsUtils.buildDs(props, typeClz);
    }

    public static DataSource buildDs(Properties props, Class<?> typeClz) {
        return (DataSource)PropsConverter.global().convert(props, typeClz);
    }

    public static Map<String, DataSource> buildDsMap(Properties props) {
        Class<?> typeClz = DsUtils.resolveType(props);
        return DsUtils.buildDsMap(props, typeClz);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, Class<?> typeDef) {
        Props rootProps;
        if (props instanceof Props) {
            rootProps = (Props)props;
        } else {
            rootProps = new Props();
            rootProps.putAll((Map)props);
        }
        Map groupProps = rootProps.getGroupedProp("");
        if (groupProps.size() == 0) {
            throw new IllegalStateException("Missing data source configuration");
        }
        LinkedHashMap<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
        groupProps.forEach((key, prop) -> {
            if (prop.size() > 1) {
                Class<?> typeClz = DsUtils.resolveTypeOrDefault((Properties)prop, typeDef);
                DataSource source = DsUtils.buildDs((Properties)prop, typeClz);
                dataSourceMap.put((String)key, source);
            }
        });
        return dataSourceMap;
    }
}

