/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.where.render.RenderedCriterion;
import org.mybatis.dynamic.sql.where.render.WhereConditionVisitor;

public class CriterionRenderer<T> {
    private final SqlCriterion<T> sqlCriterion;
    private final AtomicInteger sequence;
    private final RenderingStrategy renderingStrategy;
    private final TableAliasCalculator tableAliasCalculator;
    private final String parameterName;

    private CriterionRenderer(Builder<T> builder) {
        this.sqlCriterion = Objects.requireNonNull(((Builder)builder).sqlCriterion);
        this.sequence = Objects.requireNonNull(((Builder)builder).sequence);
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
        this.tableAliasCalculator = Objects.requireNonNull(((Builder)builder).tableAliasCalculator);
        this.parameterName = ((Builder)builder).parameterName;
    }

    public Optional<RenderedCriterion> render() {
        RenderedCriterion rc = this.sqlCriterion.condition().shouldRender() ? this.renderWithInitialCondition(this.renderCondition(), this.renderSubCriteria()) : this.renderWithoutInitialCondition(this.renderSubCriteria());
        return Optional.ofNullable(rc);
    }

    private FragmentAndParameters renderCondition() {
        WhereConditionVisitor<T> visitor = WhereConditionVisitor.withColumn(this.sqlCriterion.column()).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).withTableAliasCalculator(this.tableAliasCalculator).withParameterName(this.parameterName).build();
        return (FragmentAndParameters)this.sqlCriterion.condition().accept(visitor);
    }

    private List<RenderedCriterion> renderSubCriteria() {
        return this.sqlCriterion.mapSubCriteria(this::renderSubCriterion).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private <S> Optional<RenderedCriterion> renderSubCriterion(SqlCriterion<S> subCriterion) {
        return CriterionRenderer.withCriterion(subCriterion).withSequence(this.sequence).withRenderingStrategy(this.renderingStrategy).withTableAliasCalculator(this.tableAliasCalculator).withParameterName(this.parameterName).build().render();
    }

    private RenderedCriterion renderWithoutInitialCondition(List<RenderedCriterion> subCriteria) {
        if (subCriteria.isEmpty()) {
            return null;
        }
        return this.calculateRenderedCriterion(subCriteria);
    }

    private RenderedCriterion renderWithInitialCondition(FragmentAndParameters initialCondition, List<RenderedCriterion> subCriteria) {
        if (subCriteria.isEmpty()) {
            return this.calculateRenderedCriterion(initialCondition);
        }
        return this.calculateRenderedCriterion(initialCondition, subCriteria);
    }

    private RenderedCriterion calculateRenderedCriterion(FragmentAndParameters initialCondition) {
        return this.fromFragmentAndParameters(initialCondition);
    }

    private RenderedCriterion calculateRenderedCriterion(List<RenderedCriterion> subCriteria) {
        return this.calculateRenderedCriterion(subCriteria.get(0).fragmentAndParameters(), subCriteria.subList(1, subCriteria.size()));
    }

    private RenderedCriterion calculateRenderedCriterion(FragmentAndParameters initialCondition, List<RenderedCriterion> subCriteria) {
        FragmentCollector fc = subCriteria.stream().map(RenderedCriterion::fragmentAndParametersWithConnector).collect(FragmentCollector.collect(initialCondition));
        return this.fromFragmentAndParameters(FragmentAndParameters.withFragment(this.calculateFragment(fc)).withParameters(fc.parameters()).build());
    }

    private String calculateFragment(FragmentCollector collector) {
        if (collector.hasMultipleFragments()) {
            return collector.fragments().collect(Collectors.joining(" ", "(", ")"));
        }
        return collector.fragments().findFirst().orElse("");
    }

    private RenderedCriterion fromFragmentAndParameters(FragmentAndParameters fragmentAndParameters) {
        RenderedCriterion.Builder builder = new RenderedCriterion.Builder().withFragmentAndParameters(fragmentAndParameters);
        this.sqlCriterion.connector().ifPresent(builder::withConnector);
        return builder.build();
    }

    public static <T> Builder<T> withCriterion(SqlCriterion<T> sqlCriterion) {
        return new Builder<T>().withCriterion(sqlCriterion);
    }

    public static class Builder<T> {
        private SqlCriterion<T> sqlCriterion;
        private AtomicInteger sequence;
        private RenderingStrategy renderingStrategy;
        private TableAliasCalculator tableAliasCalculator;
        private String parameterName;

        public Builder<T> withCriterion(SqlCriterion<T> sqlCriterion) {
            this.sqlCriterion = sqlCriterion;
            return this;
        }

        public Builder<T> withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder<T> withTableAliasCalculator(TableAliasCalculator tableAliasCalculator) {
            this.tableAliasCalculator = tableAliasCalculator;
            return this;
        }

        public Builder<T> withParameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public CriterionRenderer<T> build() {
            return new CriterionRenderer(this);
        }
    }
}

