/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsNotInWhenPresent<T>
extends AbstractListValueCondition<T, IsNotInWhenPresent<T>> {
    protected IsNotInWhenPresent(Builder<T> builder) {
        super(builder);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return StringUtilities.spaceAfter(columnName) + placeholders.collect(Collectors.joining(",", "not in (", ")"));
    }

    @Override
    public IsNotInWhenPresent<T> withListEmptyCallback(Callback callback) {
        return ((Builder)((Builder)((Builder)new Builder().withValues(this.values)).withValueStreamTransformer(this.valueStreamTransformer)).withEmptyCallback(callback)).build();
    }

    public static <T> IsNotInWhenPresent<T> of(Collection<T> values) {
        return ((Builder)((Builder)new Builder<T>().withValues(values)).withValueStreamTransformer(s -> s.filter(Objects::nonNull))).build();
    }

    @SafeVarargs
    public static <T> IsNotInWhenPresent<T> of(T ... values) {
        return IsNotInWhenPresent.of(Arrays.asList(values));
    }

    public static class Builder<T>
    extends AbstractListValueCondition.AbstractListConditionBuilder<T, Builder<T>> {
        @Override
        protected Builder<T> getThis() {
            return this;
        }

        protected IsNotInWhenPresent<T> build() {
            return new IsNotInWhenPresent(this);
        }
    }
}

