/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsNotInCaseInsensitive
extends AbstractListValueCondition<String, IsNotInCaseInsensitive> {
    protected IsNotInCaseInsensitive(Builder builder) {
        super(builder);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return "upper(" + columnName + ") " + placeholders.collect(Collectors.joining(",", "not in (", ")"));
    }

    @Override
    public IsNotInCaseInsensitive withListEmptyCallback(Callback callback) {
        return ((Builder)((Builder)((Builder)new Builder().withValues(this.values)).withValueStreamTransformer(this.valueStreamTransformer)).withEmptyCallback(callback)).build();
    }

    public static IsNotInCaseInsensitive of(String ... values) {
        return IsNotInCaseInsensitive.of(Arrays.asList(values));
    }

    public static IsNotInCaseInsensitive of(Collection<String> values) {
        return ((Builder)((Builder)new Builder().withValues(values)).withValueStreamTransformer(s -> s.map(StringUtilities::safelyUpperCase))).build();
    }

    public static class Builder
    extends AbstractListValueCondition.AbstractListConditionBuilder<String, Builder> {
        @Override
        protected Builder getThis() {
            return this;
        }

        public IsNotInCaseInsensitive build() {
            return new IsNotInCaseInsensitive(this);
        }
    }
}

